/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry;

import com.datastax.driver.dse.geometry.Geometry;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.WkbSerializationProxy;
import com.datastax.internal.com_google_common.collect.ImmutableList;
import com.datastax.shaded.esri.Polyline;
import com.datastax.shaded.esri.ogc.OGCLineString;
import java.nio.ByteBuffer;
import java.util.List;

public class LineString
extends Geometry {
    private static final long serialVersionUID = -2541987694856357606L;
    private final List<Point> points;

    public static LineString fromWellKnownText(String source) {
        return new LineString(LineString.fromOgcWellKnownText(source, OGCLineString.class));
    }

    public static LineString fromWellKnownBinary(ByteBuffer source) {
        return new LineString(LineString.fromOgcWellKnownBinary(source, OGCLineString.class));
    }

    public static LineString fromGeoJson(String source) {
        return new LineString(LineString.fromOgcGeoJson(source, OGCLineString.class));
    }

    private static OGCLineString fromPoints(Point p1, Point p2, Point ... pn) {
        Polyline polyline = new Polyline((com.datastax.shaded.esri.Point)p1.getEsriGeometry(), (com.datastax.shaded.esri.Point)p2.getEsriGeometry());
        for (Point p : pn) {
            polyline.lineTo((com.datastax.shaded.esri.Point)p.getEsriGeometry());
        }
        return new OGCLineString(polyline, 0, Geometry.SPATIAL_REFERENCE_4326);
    }

    public LineString(Point p1, Point p2, Point ... pn) {
        super(LineString.fromPoints(p1, p2, pn));
        this.points = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(p1)).add(p2)).add(pn)).build();
    }

    private LineString(OGCLineString lineString) {
        super(lineString);
        this.points = LineString.getPoints(lineString);
    }

    public List<Point> getPoints() {
        return this.points;
    }

    private Object writeReplace() {
        return new WkbSerializationProxy(this.asWellKnownBinary());
    }
}

