/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry;

import com.datastax.driver.dse.geometry.Geometry;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.WkbSerializationProxy;
import com.datastax.internal.com_google_common.collect.ImmutableList;
import com.datastax.shaded.esri.Operator;
import com.datastax.shaded.esri.OperatorFactoryLocal;
import com.datastax.shaded.esri.OperatorSimplifyOGC;
import com.datastax.shaded.esri.ogc.OGCPolygon;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

public class Polygon
extends Geometry {
    private static final long serialVersionUID = 7308381476240075319L;
    private final List<Point> exteriorRing;
    private final List<List<Point>> interiorRings;

    public static Polygon fromWellKnownText(String source) {
        return new Polygon(Polygon.fromOgcWellKnownText(source, OGCPolygon.class));
    }

    public static Polygon fromWellKnownBinary(ByteBuffer source) {
        return new Polygon(Polygon.fromOgcWellKnownBinary(source, OGCPolygon.class));
    }

    public static Polygon fromGeoJson(String source) {
        return new Polygon(Polygon.fromOgcGeoJson(source, OGCPolygon.class));
    }

    public Polygon(Point p1, Point p2, Point p3, Point ... pn) {
        super(Polygon.fromPoints(p1, p2, p3, pn));
        this.exteriorRing = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(p1)).add(p2)).add(p3)).add(pn)).build();
        this.interiorRings = Collections.emptyList();
    }

    private Polygon(OGCPolygon polygon) {
        super(polygon);
        this.exteriorRing = polygon.isEmpty() ? ImmutableList.of() : Polygon.getPoints(polygon.exteriorRing());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < polygon.numInteriorRing(); ++i) {
            builder.add(Polygon.getPoints(polygon.interiorRingN(i)));
        }
        this.interiorRings = builder.build();
    }

    public List<Point> getExteriorRing() {
        return this.exteriorRing;
    }

    public List<List<Point>> getInteriorRings() {
        return this.interiorRings;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static OGCPolygon fromPoints(Point p1, Point p2, Point p3, Point ... pn) {
        com.datastax.shaded.esri.Polygon polygon = new com.datastax.shaded.esri.Polygon();
        Polygon.addPath(polygon, p1, p2, p3, pn);
        return new OGCPolygon(Polygon.simplify(polygon), Geometry.SPATIAL_REFERENCE_4326);
    }

    private static void addPath(com.datastax.shaded.esri.Polygon polygon, Point p1, Point p2, Point p3, Point[] pn) {
        polygon.startPath((com.datastax.shaded.esri.Point)p1.getEsriGeometry());
        polygon.lineTo((com.datastax.shaded.esri.Point)p2.getEsriGeometry());
        polygon.lineTo((com.datastax.shaded.esri.Point)p3.getEsriGeometry());
        for (Point p : pn) {
            polygon.lineTo((com.datastax.shaded.esri.Point)p.getEsriGeometry());
        }
    }

    private static com.datastax.shaded.esri.Polygon simplify(com.datastax.shaded.esri.Polygon polygon) {
        OperatorSimplifyOGC op = (OperatorSimplifyOGC)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.SimplifyOGC);
        return (com.datastax.shaded.esri.Polygon)op.execute(polygon, Geometry.SPATIAL_REFERENCE_4326, true, null);
    }

    private Object writeReplace() {
        return new WkbSerializationProxy(this.asWellKnownBinary());
    }

    public static class Builder {
        private final com.datastax.shaded.esri.Polygon polygon = new com.datastax.shaded.esri.Polygon();

        public Builder addRing(Point p1, Point p2, Point p3, Point ... pn) {
            Polygon.addPath(this.polygon, p1, p2, p3, pn);
            return this;
        }

        public Polygon build() {
            return new Polygon(new OGCPolygon(Polygon.simplify(this.polygon), Geometry.SPATIAL_REFERENCE_4326));
        }
    }
}

