/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.DefaultEdge;
import com.datastax.driver.dse.graph.DefaultGraphNode;
import com.datastax.driver.dse.graph.PropertyGraphNode;
import com.datastax.internal.com_google_common.collect.MultimapBuilder;
import com.datastax.shaded.jackson.core.JsonParseException;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.core.JsonToken;
import com.datastax.shaded.jackson.databind.DeserializationContext;
import com.datastax.shaded.jackson.databind.JsonNode;
import com.datastax.shaded.jackson.databind.ObjectMapper;
import com.datastax.shaded.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

class DefaultEdgeDeserializer
extends StdDeserializer<DefaultEdge> {
    DefaultEdgeDeserializer() {
        super(DefaultEdge.class);
    }

    @Override
    public DefaultEdge deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        assert (parser.getCurrentToken() == JsonToken.START_OBJECT);
        DefaultEdge element = new DefaultEdge();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            assert (parser.getCurrentToken() == JsonToken.FIELD_NAME);
            String name = parser.getCurrentName();
            parser.nextToken();
            if ("id".equals(name)) {
                assert (parser.getCurrentToken() == JsonToken.START_OBJECT);
                element = this.readId(element, parser);
                continue;
            }
            if ("label".equals(name)) {
                assert (parser.getCurrentToken() == JsonToken.VALUE_STRING);
                element = this.readLabel(element, parser);
                continue;
            }
            if ("type".equals(name)) {
                assert (parser.getCurrentToken() == JsonToken.VALUE_STRING);
                element = this.readType(element, parser);
                continue;
            }
            if ("inV".equals(name)) {
                assert (parser.getCurrentToken() == JsonToken.START_OBJECT);
                element = this.readInV(element, parser);
                continue;
            }
            if ("inVLabel".equals(name)) {
                assert (parser.getCurrentToken() == JsonToken.VALUE_STRING);
                element = this.readInVLabel(element, parser);
                continue;
            }
            if ("outV".equals(name)) {
                assert (parser.getCurrentToken() == JsonToken.START_OBJECT);
                element = this.readOutV(element, parser);
                continue;
            }
            if ("outVLabel".equals(name)) {
                assert (parser.getCurrentToken() == JsonToken.VALUE_STRING);
                element = this.readOutVLabel(element, parser);
                continue;
            }
            if ("properties".equals(name)) {
                assert (parser.getCurrentToken() == JsonToken.START_OBJECT);
                while (parser.nextToken() != JsonToken.END_OBJECT) {
                    assert (parser.getCurrentToken() == JsonToken.FIELD_NAME);
                    String key = parser.getCurrentName();
                    parser.nextToken();
                    element = this.readProperty(element, key, parser);
                }
                continue;
            }
            parser.skipChildren();
        }
        return element;
    }

    private DefaultEdge readId(DefaultEdge edge, JsonParser parser) throws IOException {
        JsonNode jacksonNode = (JsonNode)parser.readValueAsTree();
        edge.id = new DefaultGraphNode(jacksonNode, (ObjectMapper)parser.getCodec());
        return edge;
    }

    private DefaultEdge readLabel(DefaultEdge edge, JsonParser parser) throws IOException {
        edge.label = parser.readValueAs(String.class);
        return edge;
    }

    private DefaultEdge readType(DefaultEdge edge, JsonParser parser) throws IOException {
        String type = parser.readValueAs(String.class);
        if (type == null || !type.equals("edge")) {
            throw new JsonParseException(parser, String.format("Expected 'edge' type, got '%s'", type));
        }
        return edge;
    }

    private DefaultEdge readProperty(DefaultEdge edge, String propertyName, JsonParser parser) throws IOException {
        if (edge.properties == null) {
            edge.properties = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        }
        JsonNode jacksonNode = (JsonNode)parser.readValueAsTree();
        PropertyGraphNode propertyValue = new PropertyGraphNode(jacksonNode, (ObjectMapper)parser.getCodec(), propertyName, edge);
        edge.properties.put(propertyName, propertyValue);
        return edge;
    }

    private DefaultEdge readInV(DefaultEdge edge, JsonParser parser) throws IOException {
        JsonNode jacksonNode = (JsonNode)parser.readValueAsTree();
        edge.inV = new DefaultGraphNode(jacksonNode, (ObjectMapper)parser.getCodec());
        return edge;
    }

    private DefaultEdge readInVLabel(DefaultEdge edge, JsonParser parser) throws IOException {
        edge.inVLabel = parser.readValueAs(String.class);
        return edge;
    }

    private DefaultEdge readOutV(DefaultEdge edge, JsonParser parser) throws IOException {
        JsonNode jacksonNode = (JsonNode)parser.readValueAsTree();
        edge.outV = new DefaultGraphNode(jacksonNode, (ObjectMapper)parser.getCodec());
        return edge;
    }

    private DefaultEdge readOutVLabel(DefaultEdge edge, JsonParser parser) throws IOException {
        edge.outVLabel = parser.readValueAs(String.class);
        return edge;
    }
}

