/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.Element;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.Property;
import com.datastax.internal.com_google_common.base.Function;
import com.datastax.internal.com_google_common.base.Objects;
import com.datastax.internal.com_google_common.collect.ImmutableSet;
import com.datastax.internal.com_google_common.collect.Iterators;
import com.datastax.internal.com_google_common.collect.Multimap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

abstract class DefaultElement
implements Element {
    private static final Function<GraphNode, Property> GRAPH_NODE_TO_PROPERTY = new Function<GraphNode, Property>(){

        @Override
        public Property apply(GraphNode input) {
            return input.asProperty();
        }
    };
    GraphNode id;
    String label;
    Multimap<String, GraphNode> properties;

    DefaultElement() {
    }

    @Override
    public GraphNode getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Set<String> getPropertyNames() {
        if (this.properties == null || this.properties.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public Property getProperty(String name) {
        if (this.properties == null || this.properties.isEmpty() || !this.properties.containsKey(name)) {
            return null;
        }
        Iterator<? extends Property> iterator = this.getProperties(name);
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    @Override
    public Iterator<? extends Property> getProperties(String name) {
        if (this.properties == null || this.properties.isEmpty() || !this.properties.containsKey(name)) {
            return ImmutableSet.of().iterator();
        }
        return Iterators.unmodifiableIterator(Iterators.transform(this.properties.get(name).iterator(), GRAPH_NODE_TO_PROPERTY));
    }

    @Override
    public Iterator<? extends Property> getProperties() {
        if (this.properties == null || this.properties.isEmpty()) {
            return ImmutableSet.of().iterator();
        }
        return Iterators.unmodifiableIterator(Iterators.transform(this.properties.values().iterator(), GRAPH_NODE_TO_PROPERTY));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Element)) {
            return false;
        }
        Element that = (Element)o;
        return Objects.equal(this.getId(), that.getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }
}

