/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.internal.com_google_common.net.InetAddresses;
import com.datastax.shaded.jackson.core.JsonParseException;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.databind.DeserializationContext;
import com.datastax.shaded.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.net.InetAddress;

class DefaultInetAddressDeserializer<T extends InetAddress>
extends StdDeserializer<T> {
    private final Class<T> inetClass;

    DefaultInetAddressDeserializer(Class<T> inetClass) {
        super(inetClass);
        this.inetClass = inetClass;
    }

    @Override
    public T deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        String ip = parser.readValueAs(String.class);
        try {
            InetAddress inet = InetAddresses.forString(ip);
            return (T)((InetAddress)this.inetClass.cast(inet));
        }
        catch (ClassCastException e) {
            throw new JsonParseException(parser, String.format("Inet address cannot be cast to %s: %s", this.inetClass.getSimpleName(), ip), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException(parser, String.format("Expected inet address, got %s", ip), (Throwable)e);
        }
    }
}

