/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.DefaultElement;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.Vertex;
import com.datastax.driver.dse.graph.VertexProperty;
import com.datastax.internal.com_google_common.base.Function;
import com.datastax.internal.com_google_common.collect.ImmutableSet;
import com.datastax.internal.com_google_common.collect.Iterators;
import java.util.Iterator;

class DefaultVertex
extends DefaultElement
implements Vertex {
    private static final Function<GraphNode, VertexProperty> GRAPH_NODE_TO_VERTEX_PROPERTY = new Function<GraphNode, VertexProperty>(){

        @Override
        public VertexProperty apply(GraphNode input) {
            return input.asVertexProperty();
        }
    };

    DefaultVertex() {
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof Vertex && super.equals(o);
    }

    @Override
    public VertexProperty getProperty(String name) {
        if (this.properties == null || this.properties.isEmpty() || !this.properties.containsKey(name)) {
            return null;
        }
        Iterator<VertexProperty> iterator = this.getProperties(name);
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    @Override
    public Iterator<VertexProperty> getProperties(String name) {
        if (this.properties == null || this.properties.isEmpty() || !this.properties.containsKey(name)) {
            return ImmutableSet.of().iterator();
        }
        return Iterators.unmodifiableIterator(Iterators.transform(this.properties.get(name).iterator(), GRAPH_NODE_TO_VERTEX_PROPERTY));
    }

    @Override
    public Iterator<VertexProperty> getProperties() {
        if (this.properties == null || this.properties.isEmpty()) {
            return ImmutableSet.of().iterator();
        }
        return Iterators.unmodifiableIterator(Iterators.transform(this.properties.values().iterator(), GRAPH_NODE_TO_VERTEX_PROPERTY));
    }

    public String toString() {
        return "Vertex{id=" + this.id + ", label='" + this.label + '\'' + ", properties=" + this.properties + '}';
    }
}

