/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.DefaultGraphNode;
import com.datastax.driver.dse.graph.DefaultVertexProperty;
import com.datastax.driver.dse.graph.Element;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.PropertyGraphNode;
import com.datastax.driver.dse.graph.PropertyGraphNodeParser;
import com.datastax.driver.dse.graph.Vertex;
import com.datastax.driver.dse.graph.VertexProperty;
import com.datastax.internal.com_google_common.collect.Multimap;
import com.datastax.internal.com_google_common.collect.MultimapBuilder;
import com.datastax.shaded.jackson.core.JsonParseException;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.databind.DeserializationContext;
import com.datastax.shaded.jackson.databind.JsonNode;
import com.datastax.shaded.jackson.databind.ObjectMapper;
import com.datastax.shaded.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Iterator;

class DefaultVertexPropertyDeserializer
extends StdDeserializer<DefaultVertexProperty> {
    private static final String ID = "id";
    private static final String VALUE = "value";
    private static final String PROPERTIES = "properties";

    DefaultVertexPropertyDeserializer() {
        super(VertexProperty.class);
    }

    @Override
    public DefaultVertexProperty deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        if (!(parser instanceof PropertyGraphNodeParser)) {
            throw new JsonParseException(parser, "Cannot deserialize property if parser is not instance of PropertyGraphNodeParser");
        }
        PropertyGraphNodeParser propertyGraphNodeParser = (PropertyGraphNodeParser)parser;
        String name = propertyGraphNodeParser.propertyName;
        if (name == null) {
            throw new JsonParseException(parser, "Cannot deserialize property with null name");
        }
        Element parent = propertyGraphNodeParser.parent;
        if (parent == null) {
            throw new JsonParseException(parser, "Cannot deserialize property with null parent");
        }
        if (!(parent instanceof Vertex)) {
            throw new JsonParseException(parser, "Vertex property parent is not a Vertex: " + parent);
        }
        JsonNode jacksonNode = (JsonNode)parser.readValueAsTree();
        ObjectMapper objectMapper = (ObjectMapper)parser.getCodec();
        DefaultGraphNode propertyNode = new DefaultGraphNode(jacksonNode, objectMapper);
        DefaultVertexProperty vertexProperty = new DefaultVertexProperty();
        vertexProperty.id = propertyNode.get(ID);
        vertexProperty.label = name;
        vertexProperty.value = propertyNode.get(VALUE);
        vertexProperty.parent = (Vertex)parent;
        vertexProperty.properties = this.metaProperties(propertyNode, objectMapper, vertexProperty);
        return vertexProperty;
    }

    private Multimap<String, GraphNode> metaProperties(DefaultGraphNode node, ObjectMapper objectMapper, DefaultVertexProperty vertexProperty) {
        if (node == null) {
            return null;
        }
        DefaultGraphNode metaProperties = node.get(PROPERTIES);
        if (metaProperties == null) {
            return null;
        }
        Multimap metaPropertiesMap = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        Iterator<String> it = metaProperties.fieldNames();
        while (it.hasNext()) {
            String metaPropKey = it.next();
            GraphNode metaPropValue = metaProperties.get(metaPropKey);
            metaPropertiesMap.put(metaPropKey, new PropertyGraphNode(((DefaultGraphNode)metaPropValue).delegate, objectMapper, metaPropKey, vertexProperty));
        }
        return metaPropertiesMap;
    }
}

