/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.dse.graph.GraphProtocol;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.driver.dse.graph.PayloadHelper;
import com.datastax.driver.dse.graph.RegularGraphStatement;
import com.datastax.internal.com_google_common.base.Preconditions;
import com.datastax.internal.com_google_common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Map;

public class GraphOptions {
    static final String GRAPH_SOURCE_KEY = "graph-source";
    static final String GRAPH_NAME_KEY = "graph-name";
    static final String GRAPH_LANGUAGE_KEY = "graph-language";
    static final String GRAPH_READ_CONSISTENCY_KEY = "graph-read-consistency";
    static final String GRAPH_WRITE_CONSISTENCY_KEY = "graph-write-consistency";
    static final String REQUEST_TIMEOUT_KEY = "request-timeout";
    static final String GRAPH_RESULTS_KEY = "graph-results";
    public static final String DEFAULT_GRAPH_LANGUAGE = "gremlin-groovy";
    public static final String DEFAULT_GRAPH_SOURCE = "g";
    private volatile String graphLanguage = "gremlin-groovy";
    private volatile String graphSource = "g";
    private volatile String graphName;
    private volatile ConsistencyLevel graphReadConsistency;
    private volatile ConsistencyLevel graphWriteConsistency;
    private volatile Map<String, ByteBuffer> defaultPayload;
    private volatile int readTimeoutMillis = 0;
    private volatile GraphProtocol graphSubProtocol;

    public GraphOptions() {
        this.rebuildDefaultPayload();
    }

    public String getGraphLanguage() {
        return this.graphLanguage;
    }

    public GraphOptions setGraphLanguage(String graphLanguage) {
        Preconditions.checkNotNull(graphLanguage, "graphLanguage cannot be null");
        this.graphLanguage = graphLanguage;
        this.rebuildDefaultPayload();
        return this;
    }

    public String getGraphSource() {
        return this.graphSource;
    }

    public GraphOptions setGraphSource(String graphSource) {
        Preconditions.checkNotNull(graphSource, "graphSource cannot be null");
        this.graphSource = graphSource;
        this.rebuildDefaultPayload();
        return this;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public GraphOptions setGraphName(String graphName) {
        this.graphName = graphName;
        this.rebuildDefaultPayload();
        return this;
    }

    public ConsistencyLevel getGraphReadConsistencyLevel() {
        return this.graphReadConsistency;
    }

    public GraphOptions setGraphReadConsistencyLevel(ConsistencyLevel cl) {
        this.graphReadConsistency = cl;
        this.rebuildDefaultPayload();
        return this;
    }

    public ConsistencyLevel getGraphWriteConsistencyLevel() {
        return this.graphWriteConsistency;
    }

    public GraphOptions setGraphWriteConsistencyLevel(ConsistencyLevel cl) {
        this.graphWriteConsistency = cl;
        this.rebuildDefaultPayload();
        return this;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public GraphOptions setReadTimeoutMillis(int readTimeoutMillis) {
        Preconditions.checkArgument(readTimeoutMillis >= 0, "readTimeoutMillis can not be negative");
        this.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    public GraphOptions setGraphSubProtocol(GraphProtocol graphSubProtocol) {
        this.graphSubProtocol = graphSubProtocol;
        return this;
    }

    public GraphProtocol getGraphSubProtocol() {
        return this.graphSubProtocol;
    }

    public Map<String, ByteBuffer> buildPayloadWithDefaults(GraphStatement statement) {
        if (statement.getGraphLanguage() == null && statement.getGraphSource() == null && statement.getGraphReadConsistencyLevel() == null && statement.getGraphWriteConsistencyLevel() == null && statement.getGraphName() == null && statement.getGraphInternalOptions().size() == 0 && !statement.isSystemQuery() && this.graphSubProtocol == null) {
            return this.defaultPayload;
        }
        ImmutableMap.Builder<String, ByteBuffer> builder = ImmutableMap.builder();
        this.setOrDefaultText(builder, GRAPH_LANGUAGE_KEY, statement.getGraphLanguage());
        this.setOrDefaultText(builder, GRAPH_SOURCE_KEY, statement.getGraphSource());
        this.setOrDefaultCl(builder, GRAPH_READ_CONSISTENCY_KEY, statement.getGraphReadConsistencyLevel());
        this.setOrDefaultCl(builder, GRAPH_WRITE_CONSISTENCY_KEY, statement.getGraphWriteConsistencyLevel());
        if (!statement.isSystemQuery()) {
            this.setOrDefaultText(builder, GRAPH_NAME_KEY, statement.getGraphName());
        }
        if (statement.getReadTimeoutMillis() > 0) {
            this.setOrDefaultBigInt(builder, REQUEST_TIMEOUT_KEY, Long.valueOf(statement.getReadTimeoutMillis()));
        }
        if (this.graphSubProtocol != null && statement instanceof RegularGraphStatement) {
            this.setOrDefaultText(builder, GRAPH_RESULTS_KEY, this.graphSubProtocol.getProtocolReference());
        }
        for (Map.Entry<String, String> optionEntry : statement.getGraphInternalOptions().entrySet()) {
            this.setOrDefaultText(builder, optionEntry.getKey(), optionEntry.getValue());
        }
        return builder.build();
    }

    void setOrDefaultText(ImmutableMap.Builder<String, ByteBuffer> builder, String key, String value) {
        ByteBuffer bytes;
        ByteBuffer byteBuffer = bytes = value == null ? this.defaultPayload.get(key) : PayloadHelper.asBytes(value);
        if (bytes != null) {
            builder.put(key, bytes);
        }
    }

    private void setOrDefaultCl(ImmutableMap.Builder<String, ByteBuffer> builder, String key, ConsistencyLevel value) {
        ByteBuffer bytes;
        ByteBuffer byteBuffer = bytes = value == null ? this.defaultPayload.get(key) : PayloadHelper.asBytes(value.name());
        if (bytes != null) {
            builder.put(key, bytes);
        }
    }

    private void setOrDefaultBigInt(ImmutableMap.Builder<String, ByteBuffer> builder, String key, Long value) {
        ByteBuffer bytes;
        ByteBuffer byteBuffer = bytes = value == null ? this.defaultPayload.get(key) : PayloadHelper.asBytes(value);
        if (bytes != null) {
            builder.put(key, bytes);
        }
    }

    void rebuildDefaultPayload() {
        ImmutableMap.Builder<String, ByteBuffer> builder = ImmutableMap.builder();
        builder.put(GRAPH_LANGUAGE_KEY, PayloadHelper.asBytes(this.graphLanguage));
        builder.put(GRAPH_SOURCE_KEY, PayloadHelper.asBytes(this.graphSource));
        if (this.graphName != null) {
            builder.put(GRAPH_NAME_KEY, PayloadHelper.asBytes(this.graphName));
        }
        if (this.graphReadConsistency != null) {
            builder.put(GRAPH_READ_CONSISTENCY_KEY, PayloadHelper.asBytes(this.graphReadConsistency.name()));
        }
        if (this.graphWriteConsistency != null) {
            builder.put(GRAPH_WRITE_CONSISTENCY_KEY, PayloadHelper.asBytes(this.graphWriteConsistency.name()));
        }
        this.defaultPayload = builder.build();
    }
}

