/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.dse.graph.GraphJsonUtils;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.internal.com_google_common.base.Function;
import com.datastax.internal.com_google_common.collect.ImmutableList;
import com.datastax.internal.com_google_common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.List;

public class GraphResultSet
implements Iterable<GraphNode> {
    static final Function<Row, GraphNode> ROW_TO_DEFAULTGRAPHNODE = new Function<Row, GraphNode>(){

        @Override
        public GraphNode apply(Row row) {
            if (row != null) {
                String jsonString = row.getString("gremlin");
                try {
                    return GraphJsonUtils.readStringAsTree(jsonString);
                }
                catch (RuntimeException e) {
                    throw new DriverException("Could not parse the result returned by the Graph server as a JSON string : " + jsonString, e);
                }
            }
            return null;
        }
    };
    private long bulk = 0L;
    private GraphNode lastGraphNode = null;
    private final ResultSet wrapped;
    private final Function<Row, GraphNode> transformResultFunction;

    public GraphResultSet(ResultSet wrapped) {
        this(wrapped, ROW_TO_DEFAULTGRAPHNODE);
    }

    public GraphResultSet(ResultSet wrapped, Function<Row, GraphNode> transformResultFunction) {
        this.wrapped = wrapped;
        this.transformResultFunction = transformResultFunction;
    }

    public boolean isExhausted() {
        return this.wrapped.isExhausted() && this.bulk <= 1L;
    }

    public GraphNode one() {
        GraphNode results;
        if (this.bulk > 1L) {
            --this.bulk;
            return this.lastGraphNode;
        }
        GraphNode container = this.transformResultFunction.apply(this.wrapped.one());
        if (container == null) {
            return null;
        }
        if (container.get("bulk") != null) {
            this.bulk = container.get("bulk").asLong();
        }
        this.lastGraphNode = results = container.get("result");
        return results;
    }

    public List<GraphNode> all() {
        return ImmutableList.copyOf(this.iterator());
    }

    @Override
    public Iterator<GraphNode> iterator() {
        return new Iterator<GraphNode>(){

            @Override
            public boolean hasNext() {
                return !GraphResultSet.this.isExhausted();
            }

            @Override
            public GraphNode next() {
                return GraphResultSet.this.one();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Deprecated
    public int getAvailableWithoutFetching() {
        return this.wrapped.getAvailableWithoutFetching();
    }

    @Deprecated
    public boolean isFullyFetched() {
        return this.wrapped.isFullyFetched();
    }

    @Deprecated
    public ListenableFuture<GraphResultSet> fetchMoreResults() {
        return GuavaCompatibility.INSTANCE.transform(this.wrapped.fetchMoreResults(), new Function<ResultSet, GraphResultSet>(){

            @Override
            public GraphResultSet apply(ResultSet input) {
                return new GraphResultSet(input, GraphResultSet.this.transformResultFunction);
            }
        });
    }

    public ExecutionInfo getExecutionInfo() {
        return this.wrapped.getExecutionInfo();
    }

    public List<ExecutionInfo> getAllExecutionInfo() {
        return this.wrapped.getAllExecutionInfo();
    }
}

