/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.geometry.Geometry;
import com.datastax.driver.dse.geometry.LineString;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Polygon;
import com.datastax.driver.dse.graph.DefaultEdgeDeserializer;
import com.datastax.driver.dse.graph.DefaultElementSerializer;
import com.datastax.driver.dse.graph.DefaultGeometryDeserializer;
import com.datastax.driver.dse.graph.DefaultGeometrySerializer;
import com.datastax.driver.dse.graph.DefaultGraphNodeSerializer;
import com.datastax.driver.dse.graph.DefaultInetAddressDeserializer;
import com.datastax.driver.dse.graph.DefaultPathDeserializer;
import com.datastax.driver.dse.graph.DefaultPropertyDeserializer;
import com.datastax.driver.dse.graph.DefaultVertexDeserializer;
import com.datastax.driver.dse.graph.DefaultVertexPropertyDeserializer;
import com.datastax.driver.dse.graph.Edge;
import com.datastax.driver.dse.graph.Path;
import com.datastax.driver.dse.graph.Property;
import com.datastax.driver.dse.graph.Vertex;
import com.datastax.driver.dse.graph.VertexProperty;
import com.datastax.internal.com_google_common.collect.ImmutableList;
import com.datastax.internal.com_google_common.collect.ImmutableMap;
import com.datastax.shaded.jackson.core.Version;
import com.datastax.shaded.jackson.databind.JsonDeserializer;
import com.datastax.shaded.jackson.databind.JsonSerializer;
import com.datastax.shaded.jackson.databind.module.SimpleModule;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;

class GraphSON1DefaultModule
extends SimpleModule {
    GraphSON1DefaultModule(String name, Version version) {
        super(name, version, GraphSON1DefaultModule.createDeserializers(), GraphSON1DefaultModule.createSerializers());
    }

    private static Map<Class<?>, JsonDeserializer<?>> createDeserializers() {
        DefaultEdgeDeserializer edgeDeserializer = new DefaultEdgeDeserializer();
        DefaultVertexDeserializer vertexDeserializer = new DefaultVertexDeserializer();
        DefaultPathDeserializer pathDeserializer = new DefaultPathDeserializer();
        DefaultPropertyDeserializer propertyDeserializer = new DefaultPropertyDeserializer();
        DefaultVertexPropertyDeserializer vertexPropertyDeserializer = new DefaultVertexPropertyDeserializer();
        return ImmutableMap.builder().put(Edge.class, edgeDeserializer).put(Vertex.class, (DefaultEdgeDeserializer)((Object)vertexDeserializer)).put(Path.class, (DefaultEdgeDeserializer)((Object)pathDeserializer)).put(Property.class, (DefaultEdgeDeserializer)((Object)propertyDeserializer)).put(VertexProperty.class, (DefaultEdgeDeserializer)((Object)vertexPropertyDeserializer)).put((Class<VertexProperty>)InetAddress.class, (DefaultEdgeDeserializer)((Object)new DefaultInetAddressDeserializer<InetAddress>(InetAddress.class))).put(Inet4Address.class, new DefaultInetAddressDeserializer<Inet4Address>(Inet4Address.class)).put(Inet6Address.class, new DefaultInetAddressDeserializer<Inet6Address>(Inet6Address.class)).put((Class<Inet6Address>)Geometry.class, (DefaultInetAddressDeserializer<Inet6Address>)((Object)new DefaultGeometryDeserializer<Geometry>(Geometry.class))).put(Point.class, new DefaultGeometryDeserializer<Point>(Point.class)).put(LineString.class, new DefaultGeometryDeserializer<LineString>(LineString.class)).put(Polygon.class, new DefaultGeometryDeserializer<Polygon>(Polygon.class)).build();
    }

    private static List<JsonSerializer<?>> createSerializers() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(new DefaultGraphNodeSerializer())).add(new DefaultElementSerializer())).add(new DefaultGeometrySerializer())).build();
    }
}

