/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.dse.graph.GraphSON2JacksonModule;
import com.datastax.internal.com_google_common.collect.ImmutableMap;
import com.datastax.shaded.jackson.core.JsonGenerator;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.core.JsonProcessingException;
import com.datastax.shaded.jackson.databind.DeserializationContext;
import com.datastax.shaded.jackson.databind.SerializerProvider;
import com.datastax.shaded.jackson.databind.deser.std.StdDeserializer;
import com.datastax.shaded.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

class GraphSON2DriverTimeModule
extends GraphSON2JacksonModule {
    GraphSON2DriverTimeModule() {
        super("graph-graphson2drivertime");
        this.addSerializer(LocalDate.class, new JavaDriverLocalDateSerializer());
        this.addDeserializer(LocalDate.class, new JavaDriverLocalDateDeserializer());
    }

    @Override
    public Map<Class<?>, String> getTypeDefinitions() {
        ImmutableMap.Builder<Class<Date>, String> builder = ImmutableMap.builder();
        builder.put(Date.class, "Instant");
        return builder.build();
    }

    @Override
    public String getTypeNamespace() {
        return "gx";
    }

    static final class JavaDriverLocalDateSerializer
    extends StdScalarSerializer<LocalDate> {
        JavaDriverLocalDateSerializer() {
            super(LocalDate.class);
        }

        @Override
        public void serialize(LocalDate value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toString());
        }
    }

    static final class JavaDriverLocalDateDeserializer
    extends StdDeserializer<LocalDate> {
        JavaDriverLocalDateDeserializer() {
            super(LocalDate.class);
        }

        @Override
        public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String dateString = p.getText();
            try {
                Date date = ParseUtils.parseDate(dateString);
                return LocalDate.fromMillisSinceEpoch(date.getTime());
            }
            catch (ParseException e) {
                throw new IOException("Could not deserialize data as a LocalDate.", e);
            }
        }
    }
}

