/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.IgnoreJDK6Requirement;
import com.datastax.driver.dse.graph.GraphSON2JacksonModule;
import com.datastax.internal.com_google_common.collect.ImmutableMap;
import com.datastax.shaded.jackson.core.JsonGenerator;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.databind.DeserializationContext;
import com.datastax.shaded.jackson.databind.SerializerProvider;
import com.datastax.shaded.jackson.databind.deser.std.StdDeserializer;
import com.datastax.shaded.jackson.databind.jsontype.TypeSerializer;
import com.datastax.shaded.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Map;

@IgnoreJDK6Requirement
class GraphSON2JavaTimeModule
extends GraphSON2JacksonModule {
    GraphSON2JavaTimeModule() {
        super("graph-graphson2time");
        this.addSerializer(Duration.class, new DurationJacksonSerializer());
        this.addSerializer(Instant.class, new InstantJacksonSerializer());
        this.addSerializer(LocalDate.class, new LocalDateJacksonSerializer());
        this.addSerializer(LocalTime.class, new LocalTimeJacksonSerializer());
        this.addDeserializer(Duration.class, new DurationJacksonDeserializer());
        this.addDeserializer(Instant.class, new InstantJacksonDeserializer());
        this.addDeserializer(LocalDate.class, new LocalDateJacksonDeserializer());
        this.addDeserializer(LocalTime.class, new LocalTimeJacksonDeserializer());
    }

    @Override
    public Map<Class<?>, String> getTypeDefinitions() {
        ImmutableMap.Builder<Class, String> builder = ImmutableMap.builder();
        builder.put(Instant.class, "Instant");
        builder.put(Duration.class, "Duration");
        builder.put(LocalDate.class, "LocalDate");
        builder.put(LocalTime.class, "LocalTime");
        return builder.build();
    }

    @Override
    public String getTypeNamespace() {
        return "gx";
    }

    @IgnoreJDK6Requirement
    static final class LocalTimeJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<LocalTime> {
        LocalTimeJacksonDeserializer() {
            super(LocalTime.class);
        }

        @Override
        public LocalTime parse(String val) {
            return LocalTime.parse(val);
        }
    }

    @IgnoreJDK6Requirement
    static final class LocalTimeJacksonSerializer
    extends AbstractJavaTimeSerializer<LocalTime> {
        LocalTimeJacksonSerializer() {
            super(LocalTime.class);
        }
    }

    @IgnoreJDK6Requirement
    static final class LocalDateJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<LocalDate> {
        LocalDateJacksonDeserializer() {
            super(LocalDate.class);
        }

        @Override
        public LocalDate parse(String val) {
            return LocalDate.parse(val);
        }
    }

    @IgnoreJDK6Requirement
    static final class LocalDateJacksonSerializer
    extends AbstractJavaTimeSerializer<LocalDate> {
        LocalDateJacksonSerializer() {
            super(LocalDate.class);
        }
    }

    @IgnoreJDK6Requirement
    static final class InstantJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<Instant> {
        InstantJacksonDeserializer() {
            super(Instant.class);
        }

        @Override
        public Instant parse(String val) {
            return Instant.parse(val);
        }
    }

    @IgnoreJDK6Requirement
    static final class InstantJacksonSerializer
    extends AbstractJavaTimeSerializer<Instant> {
        InstantJacksonSerializer() {
            super(Instant.class);
        }
    }

    @IgnoreJDK6Requirement
    static final class DurationJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<Duration> {
        DurationJacksonDeserializer() {
            super(Duration.class);
        }

        @Override
        public Duration parse(String val) {
            return Duration.parse(val);
        }
    }

    @IgnoreJDK6Requirement
    static final class DurationJacksonSerializer
    extends AbstractJavaTimeSerializer<Duration> {
        DurationJacksonSerializer() {
            super(Duration.class);
        }
    }

    static abstract class AbstractJavaTimeSerializer<T>
    extends StdSerializer<T> {
        AbstractJavaTimeSerializer(Class<T> clazz) {
            super(clazz);
        }

        @Override
        public void serialize(T value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
            gen.writeString(value.toString());
        }

        @Override
        public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            typeSer.writeTypePrefixForScalar(value, gen);
            gen.writeString(value.toString());
            typeSer.writeTypeSuffixForScalar(value, gen);
        }
    }

    static abstract class AbstractJavaTimeJacksonDeserializer<T>
    extends StdDeserializer<T> {
        AbstractJavaTimeJacksonDeserializer(Class<T> clazz) {
            super(clazz);
        }

        abstract T parse(String var1);

        @Override
        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this.parse(jsonParser.getText());
        }
    }
}

