/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs;

import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.internal.com_google_common.reflect.TypeToken;
import java.nio.ByteBuffer;

public abstract class ParsingCodec<T>
extends TypeCodec<T> {
    private final TypeCodec<String> innerCodec;

    public ParsingCodec(Class<T> javaType) {
        this(TypeToken.of(javaType));
    }

    public ParsingCodec(TypeToken<T> javaType) {
        this(TypeCodec.varchar(), javaType);
    }

    public ParsingCodec(TypeCodec<String> innerCodec, Class<T> javaType) {
        this(innerCodec, TypeToken.of(javaType));
    }

    public ParsingCodec(TypeCodec<String> innerCodec, TypeToken<T> javaType) {
        super(innerCodec.getCqlType(), javaType);
        this.innerCodec = innerCodec;
    }

    @Override
    public ByteBuffer serialize(T value, ProtocolVersion protocolVersion) throws InvalidTypeException {
        return value == null ? null : this.innerCodec.serialize(this.toString(value), protocolVersion);
    }

    @Override
    public T deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        String value = this.innerCodec.deserialize(bytes, protocolVersion);
        return value == null ? null : (T)this.fromString(value);
    }

    @Override
    public String format(T value) throws InvalidTypeException {
        return value == null ? null : this.innerCodec.format(this.toString(value));
    }

    @Override
    public T parse(String value) throws InvalidTypeException {
        return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : (T)this.fromString(this.innerCodec.parse(value));
    }

    protected abstract String toString(T var1);

    protected abstract T fromString(String var1);
}

