/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.arrays;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.internal.com_google_common.base.Preconditions;
import java.lang.reflect.Array;

public abstract class AbstractArrayCodec<T>
extends TypeCodec<T> {
    public AbstractArrayCodec(DataType.CollectionType cqlType, Class<T> javaClass) {
        super((DataType)cqlType, javaClass);
        Preconditions.checkArgument(cqlType.getName() == DataType.Name.LIST, "Expecting CQL list type, got %s", cqlType);
        Preconditions.checkArgument(javaClass.isArray(), "Expecting Java array class, got %s", javaClass);
    }

    @Override
    public String format(T array) throws InvalidTypeException {
        if (array == null) {
            return "NULL";
        }
        int length = Array.getLength(array);
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            this.formatElement(sb, array, i);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public T parse(String value) throws InvalidTypeException {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        int idx = ParseUtils.skipSpaces(value, 0);
        if (value.charAt(idx++) != '[') {
            throw new InvalidTypeException(String.format("cannot parse list value from \"%s\", at character %d expecting '[' but got '%c'", value, idx, Character.valueOf(value.charAt(idx))));
        }
        if (value.charAt(idx = ParseUtils.skipSpaces(value, idx)) == ']') {
            return this.newInstance(0);
        }
        int length = this.getArrayLength(value, idx);
        T array = this.newInstance(length);
        int i = 0;
        while (idx < value.length()) {
            int n = this.skipLiteral(value, idx);
            this.parseElement(value.substring(idx, n), array, i);
            idx = ParseUtils.skipSpaces(value, n);
            if (value.charAt(idx) == ']') {
                return array;
            }
            idx = this.skipComma(value, idx);
            idx = ParseUtils.skipSpaces(value, idx);
            ++i;
        }
        throw new InvalidTypeException(String.format("Malformed list value \"%s\", missing closing ']'", value));
    }

    protected abstract T newInstance(int var1);

    protected abstract void formatElement(StringBuilder var1, T var2, int var3);

    protected abstract void parseElement(String var1, T var2, int var3);

    private int getArrayLength(String value, int idx) {
        int length = 1;
        while (idx < value.length()) {
            idx = this.skipLiteral(value, idx);
            if (value.charAt(idx = ParseUtils.skipSpaces(value, idx)) == ']') break;
            idx = this.skipComma(value, idx);
            idx = ParseUtils.skipSpaces(value, idx);
            ++length;
        }
        return length;
    }

    private int skipComma(String value, int idx) {
        if (value.charAt(idx) != ',') {
            throw new InvalidTypeException(String.format("Cannot parse list value from \"%s\", at character %d expecting ',' but got '%c'", value, idx, Character.valueOf(value.charAt(idx))));
        }
        return idx + 1;
    }

    private int skipLiteral(String value, int idx) {
        try {
            return ParseUtils.skipCQLValue(value, idx);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidTypeException(String.format("Cannot parse list value from \"%s\", invalid CQL value at character %d", value, idx), e);
        }
    }
}

