/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.date;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import java.text.ParseException;

public class SimpleTimestampCodec
extends TypeCodec.PrimitiveLongCodec {
    public static final SimpleTimestampCodec instance = new SimpleTimestampCodec();

    public SimpleTimestampCodec() {
        super(DataType.timestamp());
    }

    @Override
    public ByteBuffer serializeNoBoxing(long value, ProtocolVersion protocolVersion) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(0, value);
        return bb;
    }

    @Override
    public long deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return 0L;
        }
        if (bytes.remaining() != 8) {
            throw new InvalidTypeException("Invalid 64-bits long value, expecting 8 bytes but got " + bytes.remaining());
        }
        return bytes.getLong(bytes.position());
    }

    @Override
    public Long parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (ParseUtils.isQuoted(value)) {
            value = ParseUtils.unquote(value);
        }
        if (ParseUtils.isLongLiteral(value)) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", value), e);
            }
        }
        try {
            return ParseUtils.parseDate(value).getTime();
        }
        catch (ParseException e) {
            throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", value), e);
        }
    }

    @Override
    public String format(Long value) {
        if (value == null) {
            return "NULL";
        }
        return ParseUtils.quote(Long.toString(value));
    }
}

