/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.jdk8;

import com.datastax.driver.core.CodecUtils;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.IgnoreJDK6Requirement;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

@IgnoreJDK6Requirement
public class LocalDateCodec
extends TypeCodec<LocalDate> {
    public static final LocalDateCodec instance = new LocalDateCodec();
    private static final LocalDate EPOCH = LocalDate.of(1970, 1, 1);

    private LocalDateCodec() {
        super(DataType.date(), LocalDate.class);
    }

    @Override
    public ByteBuffer serialize(LocalDate value, ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        long days = ChronoUnit.DAYS.between(EPOCH, value);
        int unsigned = CodecUtils.fromSignedToUnsignedInt((int)days);
        return LocalDateCodec.cint().serializeNoBoxing(unsigned, protocolVersion);
    }

    @Override
    public LocalDate deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        int unsigned = LocalDateCodec.cint().deserializeNoBoxing(bytes, protocolVersion);
        int signed = CodecUtils.fromUnsignedToSignedInt(unsigned);
        return EPOCH.plusDays(signed);
    }

    @Override
    public String format(LocalDate value) {
        if (value == null) {
            return "NULL";
        }
        return ParseUtils.quote(DateTimeFormatter.ISO_LOCAL_DATE.format(value));
    }

    @Override
    public LocalDate parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (ParseUtils.isQuoted(value)) {
            value = ParseUtils.unquote(value);
        }
        if (ParseUtils.isLongLiteral(value)) {
            int days;
            long raw;
            try {
                raw = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value));
            }
            try {
                days = CodecUtils.fromCqlDateToDaysSinceEpoch(raw);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value));
            }
            return EPOCH.plusDays(days);
        }
        try {
            return LocalDate.parse(value, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (RuntimeException e) {
            throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value));
        }
    }
}

