/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.jdk8;

import com.datastax.driver.core.IgnoreJDK6Requirement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.extras.codecs.MappingCodec;
import com.datastax.internal.com_google_common.reflect.TypeParameter;
import com.datastax.internal.com_google_common.reflect.TypeToken;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

@IgnoreJDK6Requirement
public class OptionalCodec<T>
extends MappingCodec<Optional<T>, T> {
    private final Predicate<T> isAbsent;

    public OptionalCodec(TypeCodec<T> codec) {
        this(codec, new Predicate<T>(){

            @Override
            public boolean test(T input) {
                return input == null || input instanceof Collection && ((Collection)input).isEmpty() || input instanceof Map && ((Map)input).isEmpty();
            }
        });
    }

    public OptionalCodec(TypeCodec<T> codec, Predicate<T> isAbsent) {
        super(codec, new TypeToken<Optional<T>>(){}.where(new TypeParameter<T>(){}, codec.getJavaType()));
        this.isAbsent = isAbsent;
    }

    @Override
    protected Optional<T> deserialize(T value) {
        return this.isAbsent(value) ? Optional.empty() : Optional.of(value);
    }

    @Override
    protected T serialize(Optional<T> value) {
        return value.isPresent() ? value.get() : this.absentValue();
    }

    protected T absentValue() {
        return null;
    }

    protected boolean isAbsent(T value) {
        return this.isAbsent.test(value);
    }
}

