/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.joda;

import com.datastax.driver.core.CodecUtils;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class LocalDateCodec
extends TypeCodec<LocalDate> {
    public static final LocalDateCodec instance = new LocalDateCodec();
    private static final LocalDate EPOCH = new LocalDate(1970, 1, 1);
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd").withZoneUTC();

    private LocalDateCodec() {
        super(DataType.date(), LocalDate.class);
    }

    @Override
    public ByteBuffer serialize(LocalDate value, ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        Days days = Days.daysBetween(EPOCH, value);
        int unsigned = CodecUtils.fromSignedToUnsignedInt(days.getDays());
        return LocalDateCodec.cint().serializeNoBoxing(unsigned, protocolVersion);
    }

    @Override
    public LocalDate deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        int unsigned = LocalDateCodec.cint().deserializeNoBoxing(bytes, protocolVersion);
        int signed = CodecUtils.fromUnsignedToSignedInt(unsigned);
        return EPOCH.plusDays(signed);
    }

    @Override
    public String format(LocalDate value) {
        if (value == null) {
            return "NULL";
        }
        return ParseUtils.quote(FORMATTER.print(value));
    }

    @Override
    public LocalDate parse(String value) {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (ParseUtils.isQuoted(value)) {
            value = ParseUtils.unquote(value);
        }
        if (ParseUtils.isLongLiteral(value)) {
            int days;
            long raw;
            try {
                raw = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value));
            }
            try {
                days = CodecUtils.fromCqlDateToDaysSinceEpoch(raw);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value));
            }
            return EPOCH.plusDays(days);
        }
        try {
            return LocalDate.parse(value, FORMATTER);
        }
        catch (RuntimeException e) {
            throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value));
        }
    }
}

