/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SchemaChangeListenerBase;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.utils.MoreObjects;
import com.datastax.driver.mapping.AccessorMapper;
import com.datastax.driver.mapping.AnnotationParser;
import com.datastax.driver.mapping.EntityMapper;
import com.datastax.driver.mapping.MappedUDTCodec;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingConfiguration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingManager.class);
    private final Session session;
    private final MappingConfiguration configuration;
    final int protocolVersionAsInt;
    private final ConcurrentHashMap<CacheKey, Mapper<?>> mappers = new ConcurrentHashMap();
    private final ConcurrentHashMap<CacheKey, MappedUDTCodec<?>> udtCodecs = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, Object> accessors = new ConcurrentHashMap();

    public MappingManager(Session session) {
        this(session, MappingManager.getProtocolVersion(session));
    }

    private static ProtocolVersion getProtocolVersion(Session session) {
        session.init();
        return session.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
    }

    public MappingManager(Session session, ProtocolVersion protocolVersion) {
        this(session, MappingConfiguration.builder().build(), protocolVersion);
    }

    public MappingManager(Session session, MappingConfiguration configuration) {
        this(session, configuration, MappingManager.getProtocolVersion(session));
    }

    public MappingManager(Session session, MappingConfiguration configuration, ProtocolVersion protocolVersion) {
        this.session = session;
        this.configuration = configuration;
        this.protocolVersionAsInt = protocolVersion.toInt();
        session.getCluster().register(new SchemaChangeListenerBase(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTableRemoved(TableMetadata table) {
                ConcurrentHashMap concurrentHashMap = MappingManager.this.mappers;
                synchronized (concurrentHashMap) {
                    Iterator it = MappingManager.this.mappers.values().iterator();
                    while (it.hasNext()) {
                        Mapper mapper = (Mapper)it.next();
                        if (!mapper.getTableMetadata().equals(table)) continue;
                        LOGGER.error("Table {} has been removed; existing mappers for @Entity annotated {} will not work anymore", (Object)table.getName(), (Object)mapper.getMappedClass());
                        it.remove();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTableChanged(TableMetadata current, TableMetadata previous) {
                ConcurrentHashMap concurrentHashMap = MappingManager.this.mappers;
                synchronized (concurrentHashMap) {
                    Iterator it = MappingManager.this.mappers.values().iterator();
                    while (it.hasNext()) {
                        Mapper mapper = (Mapper)it.next();
                        if (!mapper.getTableMetadata().equals(previous)) continue;
                        LOGGER.warn("Table {} has been altered; existing mappers for @Entity annotated {} might not work properly anymore", (Object)previous.getName(), (Object)mapper.getMappedClass());
                        it.remove();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUserTypeRemoved(UserType type) {
                ConcurrentHashMap concurrentHashMap = MappingManager.this.udtCodecs;
                synchronized (concurrentHashMap) {
                    Iterator it = MappingManager.this.udtCodecs.values().iterator();
                    while (it.hasNext()) {
                        MappedUDTCodec codec = (MappedUDTCodec)it.next();
                        if (!type.equals(codec.getCqlType())) continue;
                        LOGGER.error("User type {} has been removed; existing mappers for @UDT annotated {} will not work anymore", (Object)type, (Object)codec.getUdtClass());
                        it.remove();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUserTypeChanged(UserType current, UserType previous) {
                ConcurrentHashMap concurrentHashMap = MappingManager.this.udtCodecs;
                synchronized (concurrentHashMap) {
                    HashSet deletedCodecs = new HashSet();
                    Iterator it = MappingManager.this.udtCodecs.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        MappedUDTCodec codec = (MappedUDTCodec)entry.getValue();
                        if (!previous.equals(codec.getCqlType())) continue;
                        LOGGER.warn("User type {} has been altered; existing mappers for @UDT annotated {} might not work properly anymore", (Object)previous, (Object)codec.getUdtClass());
                        deletedCodecs.add(entry.getKey());
                        it.remove();
                    }
                    for (CacheKey key : deletedCodecs) {
                        try {
                            MappingManager.this.getUDTCodec(key.klass, key.keyspace);
                        }
                        catch (Exception e) {
                            LOGGER.error("Could not update mapping for @UDT annotated " + key.klass, e);
                        }
                    }
                }
            }
        });
    }

    public Session getSession() {
        return this.session;
    }

    public MappingConfiguration getConfiguration() {
        return this.configuration;
    }

    public <T> Mapper<T> mapper(Class<T> klass, String keyspace) {
        return this.getMapper(klass, keyspace);
    }

    public <T> Mapper<T> mapper(Class<T> klass) {
        return this.mapper(klass, null);
    }

    public <T> TypeCodec<T> udtCodec(Class<T> klass, String keyspace) {
        return this.getUDTCodec(klass, keyspace);
    }

    public <T> TypeCodec<T> udtCodec(Class<T> klass) {
        return this.udtCodec(klass, null);
    }

    public <T> T createAccessor(Class<T> klass) {
        return this.getAccessor(klass);
    }

    private <T> Mapper<T> getMapper(Class<T> klass, String keyspace) {
        EntityMapper<T> entityMapper;
        Mapper<?> old;
        CacheKey cacheKey = new CacheKey(klass, keyspace);
        Mapper<Object> mapper = this.mappers.get(cacheKey);
        if (mapper == null && (old = this.mappers.putIfAbsent(cacheKey, mapper = new Mapper<T>(this, klass, entityMapper = AnnotationParser.parseEntity(klass, keyspace, this)))) != null) {
            mapper = old;
        }
        return mapper;
    }

    <T> TypeCodec<T> getUDTCodec(Class<T> mappedClass, String keyspace) {
        CacheKey cacheKey = new CacheKey(mappedClass, keyspace);
        MappedUDTCodec<Object> codec = this.udtCodecs.get(cacheKey);
        if (codec == null) {
            codec = AnnotationParser.parseUDT(mappedClass, keyspace, this);
            this.session.getCluster().getConfiguration().getCodecRegistry().register((TypeCodec<?>)codec);
            MappedUDTCodec<?> old = this.udtCodecs.putIfAbsent(cacheKey, codec);
            if (old != null) {
                codec = old;
            }
        }
        return codec;
    }

    private <T> T getAccessor(Class<T> klass) {
        Object accessor = this.accessors.get(klass);
        if (accessor == null) {
            AccessorMapper<T> mapper = AnnotationParser.parseAccessor(klass, this);
            mapper.prepare(this);
            accessor = mapper.createProxy();
            Object old = this.accessors.putIfAbsent(klass, accessor);
            if (old != null) {
                accessor = old;
            }
        }
        return (T)accessor;
    }

    private static class CacheKey {
        final Class<?> klass;
        final String keyspace;

        CacheKey(Class<?> klass, String keyspace) {
            this.klass = klass;
            this.keyspace = keyspace;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof CacheKey) {
                CacheKey that = (CacheKey)other;
                return this.klass.equals(that.klass) && MoreObjects.equal(this.keyspace, that.keyspace);
            }
            return false;
        }

        public int hashCode() {
            return MoreObjects.hashCode(this.klass, this.keyspace);
        }
    }
}

