/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.mapping.AliasedMappedProperty;
import com.datastax.driver.mapping.EntityMapper;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import java.util.Collection;
import java.util.Set;

enum QueryType {
    SAVE{

        @Override
        String makePreparedQueryString(TableMetadata table, EntityMapper<?> mapper, MappingManager manager, Set<AliasedMappedProperty> columns, Collection<Mapper.Option> options) {
            Insert insert = table == null ? QueryBuilder.insertInto(mapper.keyspace, mapper.table) : QueryBuilder.insertInto(table);
            for (AliasedMappedProperty col : columns) {
                if (col.mappedProperty.isComputed()) continue;
                insert.value(col.mappedProperty.getMappedName(), QueryBuilder.bindMarker());
            }
            for (Mapper.Option opt : options) {
                opt.validate(SAVE, manager);
                opt.modifyQueryString(insert);
            }
            return insert.toString();
        }
    }
    ,
    GET{

        @Override
        String makePreparedQueryString(TableMetadata table, EntityMapper<?> mapper, MappingManager manager, Set<AliasedMappedProperty> columns, Collection<Mapper.Option> options) {
            Select.Selection selection = QueryBuilder.select();
            for (AliasedMappedProperty col : mapper.allColumns) {
                Select.SelectionOrAlias column;
                Select.SelectionOrAlias selectionOrAlias = column = col.mappedProperty.isComputed() ? selection.raw(col.mappedProperty.getMappedName()) : selection.column(col.mappedProperty.getMappedName());
                if (col.alias == null) {
                    selection = column;
                    continue;
                }
                selection = column.as(col.alias);
            }
            Select select = table == null ? selection.from(mapper.keyspace, mapper.table) : selection.from(table);
            Select.Where where = select.where();
            for (int i = 0; i < mapper.primaryKeySize(); ++i) {
                where.and(QueryBuilder.eq(mapper.getPrimaryKeyColumn((int)i).mappedProperty.getMappedName(), QueryBuilder.bindMarker()));
            }
            for (Mapper.Option option : options) {
                option.validate(GET, manager);
                option.modifyQueryString(select);
            }
            return select.toString();
        }
    }
    ,
    DEL{

        @Override
        String makePreparedQueryString(TableMetadata table, EntityMapper<?> mapper, MappingManager manager, Set<AliasedMappedProperty> columns, Collection<Mapper.Option> options) {
            Delete delete = table == null ? QueryBuilder.delete().all().from(mapper.keyspace, mapper.table) : QueryBuilder.delete().all().from(table);
            Delete.Where where = delete.where();
            for (int i = 0; i < mapper.primaryKeySize(); ++i) {
                where.and(QueryBuilder.eq(mapper.getPrimaryKeyColumn((int)i).mappedProperty.getMappedName(), QueryBuilder.bindMarker()));
            }
            for (Mapper.Option option : options) {
                option.validate(DEL, manager);
                option.modifyQueryString(delete);
            }
            return delete.toString();
        }
    };


    abstract String makePreparedQueryString(TableMetadata var1, EntityMapper<?> var2, MappingManager var3, Set<AliasedMappedProperty> var4, Collection<Mapper.Option> var5);
}

