/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.internal.com_google_common.collect;

import com.datastax.internal.com_google_common.annotations.GwtCompatible;
import com.datastax.internal.com_google_common.base.Preconditions;
import com.datastax.internal.com_google_common.collect.AbstractIterator;
import com.datastax.internal.com_google_common.collect.Lists;
import java.util.Collections;
import java.util.Queue;

@GwtCompatible
class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(T ... elements) {
        this.queue = Lists.newLinkedList();
        Collections.addAll(this.queue, elements);
    }

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    public T computeNext() {
        return this.queue.isEmpty() ? this.endOfData() : this.queue.remove();
    }
}

