/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri;

import com.datastax.shaded.esri.Bufferer;
import com.datastax.shaded.esri.Envelope2D;
import com.datastax.shaded.esri.Geometry;
import com.datastax.shaded.esri.GeometryCursor;
import com.datastax.shaded.esri.ProgressTracker;
import com.datastax.shaded.esri.SpatialReference;
import com.datastax.shaded.esri.SpatialReferenceImpl;

class OperatorBufferCursor
extends GeometryCursor {
    private GeometryCursor m_inputGeoms;
    private SpatialReferenceImpl m_Spatial_reference;
    private ProgressTracker m_progress_tracker;
    private double[] m_distances;
    private Envelope2D m_currentUnionEnvelope2D;
    private boolean m_bUnion;
    private int m_index = -1;
    private int m_dindex;

    OperatorBufferCursor(GeometryCursor inputGeoms, SpatialReference sr, double[] distances, boolean b_union, ProgressTracker progress_tracker) {
        this.m_inputGeoms = inputGeoms;
        this.m_Spatial_reference = (SpatialReferenceImpl)sr;
        this.m_distances = distances;
        this.m_bUnion = b_union;
        this.m_currentUnionEnvelope2D = new Envelope2D();
        this.m_currentUnionEnvelope2D.setEmpty();
        this.m_dindex = -1;
        this.m_progress_tracker = progress_tracker;
    }

    @Override
    public Geometry next() {
        Geometry geom = this.m_inputGeoms.next();
        if (geom != null) {
            this.m_index = this.m_inputGeoms.getGeometryID();
            if (this.m_dindex + 1 < this.m_distances.length) {
                ++this.m_dindex;
            }
            return this.buffer(geom, this.m_distances[this.m_dindex]);
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    Geometry buffer(Geometry geom, double distance) {
        return Bufferer.buffer(geom, distance, this.m_Spatial_reference, Double.NaN, 96, this.m_progress_tracker);
    }
}

