/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.TextContainer;
import com.vladsch.flexmark.util.misc.BitFieldSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;
import org.jetbrains.annotations.NotNull;

public final class Text
extends Node
implements TextContainer {
    public Text() {
    }

    public Text(BasedSequence chars) {
        super(chars);
    }

    public Text(String chars) {
        super(BasedSequence.of(chars));
    }

    public Text(String chars, BasedSequence baseSeq) {
        super(PrefixedSubSequence.prefixOf(chars, baseSeq));
    }

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return EMPTY_SEGMENTS;
    }

    @Override
    public boolean collectText(ISequenceBuilder<? extends ISequenceBuilder<?, BasedSequence>, BasedSequence> out, int flags, NodeVisitor nodeVisitor) {
        if (BitFieldSet.any(flags, F_NODE_TEXT)) {
            out.append(this.getChars());
        } else {
            ReplacedTextMapper textMapper = new ReplacedTextMapper(this.getChars());
            BasedSequence unescaped = Escaping.unescape(this.getChars(), textMapper);
            out.append(unescaped);
        }
        return false;
    }

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        this.astExtraChars(out);
        if (this.getChars() instanceof PrefixedSubSequence) {
            Text.astChars(out, this.getChars(), "text");
        }
    }

    @Override
    @NotNull
    protected String toStringAttributes() {
        return "text=" + this.getChars();
    }
}

