/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.codecsupport;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.UserType;
import io.nosqlbench.activitytype.cql.codecsupport.UserCodecProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDTCodecInjector {
    private static final Logger logger = LoggerFactory.getLogger(UDTCodecInjector.class);
    private List<UserCodecProvider> codecProviders = new ArrayList<UserCodecProvider>();
    private List<UserType> userTypes = new ArrayList<UserType>();

    public void injectUserProvidedCodecs(Session session, boolean allowAcrossKeyspaces) {
        CodecRegistry registry = session.getCluster().getConfiguration().getCodecRegistry();
        ServiceLoader<UserCodecProvider> codecLoader = ServiceLoader.load(UserCodecProvider.class);
        for (UserCodecProvider userCodecProvider : codecLoader) {
            this.codecProviders.add(userCodecProvider);
        }
        for (UserCodecProvider codecProvider : this.codecProviders) {
            codecProvider.registerCodecsForCluster(session, true);
        }
    }
}

