/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.codecsupport;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UserType;
import io.nosqlbench.activitytype.cql.codecsupport.CQLUserTypeNames;
import io.nosqlbench.activitytype.cql.codecsupport.UDTCodecClasses;
import io.nosqlbench.activitytype.cql.codecsupport.UDTJavaType;
import io.nosqlbench.activitytype.cql.codecsupport.UDTTransformCodec;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserCodecProvider {
    private static final Logger logger = LoggerFactory.getLogger(UserCodecProvider.class);

    public List<UDTTransformCodec> registerCodecsForCluster(Session session, boolean allowAcrossKeyspaces) {
        ArrayList<UDTTransformCodec> typeCodecs = new ArrayList<UDTTransformCodec>();
        ArrayList<KeyspaceMetadata> ksMetas = new ArrayList<KeyspaceMetadata>(session.getCluster().getMetadata().getKeyspaces());
        for (KeyspaceMetadata keyspace : ksMetas) {
            List<UDTTransformCodec> keyspaceCodecs = this.registerCodecsForKeyspace(session, keyspace.getName());
            for (UDTTransformCodec typeCodec : keyspaceCodecs) {
                if (typeCodecs.contains(typeCodec) && !allowAcrossKeyspaces) {
                    throw new RuntimeException("codec " + typeCodec + " could be registeredin multiple keyspaces, but this is not allowed.");
                }
                typeCodecs.add(typeCodec);
                logger.debug("Found user-provided codec for ks:" + keyspace + ", udt:" + typeCodec);
            }
        }
        return typeCodecs;
    }

    public List<UDTTransformCodec> registerCodecsForKeyspace(Session session, String keyspace) {
        CodecRegistry registry = session.getCluster().getConfiguration().getCodecRegistry();
        ArrayList<UDTTransformCodec> codecsForKeyspace = new ArrayList<UDTTransformCodec>();
        KeyspaceMetadata ksMeta = session.getCluster().getMetadata().getKeyspace(keyspace);
        if (ksMeta == null) {
            logger.warn("No metadata for " + keyspace);
            return Collections.emptyList();
        }
        Collection<UserType> typesInKeyspace = ksMeta.getUserTypes();
        List<Class<? extends UDTTransformCodec>> providedCodecClasses = this.getUDTCodecClasses();
        HashMap<UserType, Class<? extends UDTTransformCodec>> codecMap = new HashMap<UserType, Class<? extends UDTTransformCodec>>();
        Iterator<Class<UDTTransformCodec<Object>>> iterator = providedCodecClasses.iterator();
        while (iterator.hasNext()) {
            Class<? extends UDTTransformCodec> providedCodecClass;
            Class<? extends UDTTransformCodec> udtCodecClass = providedCodecClass = iterator.next();
            List<String> targetUDTTypes = this.getUDTTypeNames(udtCodecClass);
            for (UserType keyspaceUserType : typesInKeyspace) {
                String globalTypeName;
                String ksTypeName = keyspaceUserType.getTypeName();
                String string = globalTypeName = ksTypeName.contains(".") ? ksTypeName.split("\\.", 2)[1] : ksTypeName;
                if (!targetUDTTypes.contains(ksTypeName) && !targetUDTTypes.contains(globalTypeName)) continue;
                codecMap.put(keyspaceUserType, udtCodecClass);
            }
        }
        for (UserType userType : codecMap.keySet()) {
            Class codecClass = (Class)codecMap.get(userType);
            Class<?> udtJavaType = this.getUDTJavaType(codecClass);
            UDTTransformCodec udtCodec = this.instantiate(userType, codecClass, udtJavaType);
            codecsForKeyspace.add(udtCodec);
            registry.register((TypeCodec<?>)udtCodec);
            logger.info("registered codec:" + udtCodec);
        }
        return codecsForKeyspace;
    }

    private UDTTransformCodec instantiate(UserType key, Class<? extends UDTTransformCodec> codecClass, Class<?> javaType) {
        try {
            Constructor<? extends UDTTransformCodec> ctor = codecClass.getConstructor(UserType.class, Class.class);
            UDTTransformCodec typeCodec = ctor.newInstance(key, javaType);
            return typeCodec;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private List<Class<? extends UDTTransformCodec>> getUDTCodecClasses() {
        UDTCodecClasses[] annotationsByType = (UDTCodecClasses[])this.getClass().getAnnotationsByType(UDTCodecClasses.class);
        List<Class<? extends UDTTransformCodec>> codecClasses = Arrays.stream(annotationsByType).map(UDTCodecClasses::value).flatMap(Arrays::stream).collect(Collectors.toList());
        return codecClasses;
    }

    private List<String> getUDTTypeNames(Class<? extends UDTTransformCodec> codecClass) {
        CQLUserTypeNames[] annotationsByType = (CQLUserTypeNames[])codecClass.getAnnotationsByType(CQLUserTypeNames.class);
        ArrayList<String> cqlTypeNames = new ArrayList<String>();
        for (CQLUserTypeNames cqlUserTypeNames : annotationsByType) {
            cqlTypeNames.addAll(Arrays.asList(cqlUserTypeNames.value()));
        }
        return cqlTypeNames;
    }

    private Class<?> getUDTJavaType(Class<? extends UDTTransformCodec> codecClass) {
        UDTJavaType[] annotationsByType = (UDTJavaType[])codecClass.getAnnotationsByType(UDTJavaType.class);
        Class javaType = Arrays.stream(annotationsByType).map(UDTJavaType::value).findFirst().orElseThrow(() -> new RuntimeException("Unable to find UDTJavaType annotation for " + codecClass.getCanonicalName()));
        return javaType;
    }
}

