/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import io.nosqlbench.engine.api.activityconfig.ParsedStmt;
import io.nosqlbench.engine.api.activityconfig.yaml.StmtDef;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CQLBindHelper {
    private static final Pattern stmtToken = Pattern.compile("\\?(\\w+[-_\\d\\w]*)|\\{(\\w+[-_\\d\\w.]*)}");

    public static Statement rebindUnappliedStatement(Statement statement, ColumnDefinitions defs, Row row) {
        for (ColumnDefinitions.Definition def : defs) {
            String name = def.getName();
            def.getType();
            if (name.equals("[applied]")) continue;
            DataType.Name typeName = def.getType().getName();
            switch (typeName) {
                case ASCII: {
                    ((BoundStatement)statement).bind(new Object[0]).setString(name, row.getString(name));
                }
                case VARCHAR: {
                    ((BoundStatement)statement).bind(new Object[0]).setString(name, row.getString(name));
                }
                case TEXT: {
                    ((BoundStatement)statement).bind(new Object[0]).setString(name, row.getString(name));
                }
                case BIGINT: {
                    ((BoundStatement)statement).bind(new Object[0]).setLong(name, row.getLong(name));
                }
                case COUNTER: {
                    ((BoundStatement)statement).bind(new Object[0]).setLong(name, row.getLong(name));
                }
                case BLOB: {
                    ((BoundStatement)statement).bind(new Object[0]).setBytes(name, row.getBytes(name));
                }
                case CUSTOM: {
                    throw new RuntimeException("The diagnostic binder does not understand custom types yet.");
                }
                case BOOLEAN: {
                    ((BoundStatement)statement).bind(new Object[0]).setBool(name, row.getBool(name));
                }
                case DECIMAL: {
                    ((BoundStatement)statement).bind(new Object[0]).setDecimal(name, row.getDecimal(name));
                }
                case DOUBLE: {
                    ((BoundStatement)statement).bind(new Object[0]).setDouble(name, row.getDouble(name));
                }
                case FLOAT: {
                    ((BoundStatement)statement).bind(new Object[0]).setFloat(name, row.getFloat(name));
                }
                case INET: {
                    ((BoundStatement)statement).bind(new Object[0]).setInet(name, row.getInet(name));
                }
                case INT: {
                    ((BoundStatement)statement).bind(new Object[0]).setInt(name, row.getInt(name));
                }
                case TIMESTAMP: {
                    ((BoundStatement)statement).bind(new Object[0]).setTimestamp(name, row.getTimestamp(name));
                }
                case UUID: {
                    ((BoundStatement)statement).bind(new Object[0]).setUUID(name, row.getUUID(name));
                }
                case TIMEUUID: {
                    ((BoundStatement)statement).bind(new Object[0]).setUUID(name, row.getUUID(name));
                }
                case VARINT: {
                    ((BoundStatement)statement).bind(new Object[0]).setInt(name, row.getInt(name));
                }
                case UDT: {
                    ((BoundStatement)statement).bind(new Object[0]).setUDTValue(name, row.getUDTValue(name));
                }
                case TUPLE: {
                    ((BoundStatement)statement).bind(new Object[0]).setTupleValue(name, row.getTupleValue(name));
                }
                case SMALLINT: {
                    ((BoundStatement)statement).bind(new Object[0]).setInt(name, row.getInt(name));
                }
                case TINYINT: {
                    ((BoundStatement)statement).bind(new Object[0]).setInt(name, row.getInt(name));
                }
                case DATE: {
                    ((BoundStatement)statement).bind(new Object[0]).setDate(name, row.getDate(name));
                }
                case TIME: {
                    ((BoundStatement)statement).bind(new Object[0]).setTime(name, row.getTime(name));
                }
            }
            throw new RuntimeException("Unrecognized type:" + typeName);
        }
        return statement;
    }

    public static BoundStatement bindStatement(Statement statement, String name, Object value, DataType.Name typeName) {
        switch (typeName) {
            case ASCII: {
                return ((BoundStatement)statement).bind(new Object[0]).setString(name, (String)value);
            }
            case VARCHAR: {
                return ((BoundStatement)statement).bind(new Object[0]).setString(name, (String)value);
            }
            case TEXT: {
                return ((BoundStatement)statement).bind(new Object[0]).setString(name, (String)value);
            }
            case BIGINT: {
                return ((BoundStatement)statement).bind(new Object[0]).setLong(name, (long)((Long)value));
            }
            case COUNTER: {
                return ((BoundStatement)statement).bind(new Object[0]).setLong(name, (long)((Long)value));
            }
            case BLOB: {
                return ((BoundStatement)statement).bind(new Object[0]).setBytes(name, (ByteBuffer)value);
            }
            case CUSTOM: {
                throw new RuntimeException("The diagnostic binder does not understand custom types yet.");
            }
            case BOOLEAN: {
                return ((BoundStatement)statement).bind(new Object[0]).setBool(name, (boolean)((Boolean)value));
            }
            case DECIMAL: {
                return ((BoundStatement)statement).bind(new Object[0]).setDecimal(name, (BigDecimal)value);
            }
            case DOUBLE: {
                return ((BoundStatement)statement).bind(new Object[0]).setDouble(name, (double)((Double)value));
            }
            case FLOAT: {
                return ((BoundStatement)statement).bind(new Object[0]).setFloat(name, ((Float)value).floatValue());
            }
            case INET: {
                return ((BoundStatement)statement).bind(new Object[0]).setInet(name, (InetAddress)value);
            }
            case INT: {
                return ((BoundStatement)statement).bind(new Object[0]).setInt(name, (int)((Integer)value));
            }
            case TIMESTAMP: {
                return ((BoundStatement)statement).bind(new Object[0]).setTimestamp(name, (Date)value);
            }
            case UUID: {
                return ((BoundStatement)statement).bind(new Object[0]).setUUID(name, (UUID)value);
            }
            case TIMEUUID: {
                return ((BoundStatement)statement).bind(new Object[0]).setUUID(name, (UUID)value);
            }
            case VARINT: {
                return ((BoundStatement)statement).bind(new Object[0]).setInt(name, (int)((Integer)value));
            }
            case UDT: {
                return ((BoundStatement)statement).bind(new Object[0]).setUDTValue(name, (UDTValue)value);
            }
            case TUPLE: {
                return ((BoundStatement)statement).bind(new Object[0]).setTupleValue(name, (TupleValue)value);
            }
            case SMALLINT: {
                return ((BoundStatement)statement).bind(new Object[0]).setInt(name, (int)((Integer)value));
            }
            case TINYINT: {
                return ((BoundStatement)statement).bind(new Object[0]).setInt(name, (int)((Integer)value));
            }
            case DATE: {
                return ((BoundStatement)statement).bind(new Object[0]).setDate(name, (LocalDate)value);
            }
            case TIME: {
                return ((BoundStatement)statement).bind(new Object[0]).setTime(name, (long)((Long)value));
            }
        }
        throw new RuntimeException("Unrecognized type:" + typeName);
    }

    public static Map<String, String> parseAndGetSpecificBindings(StmtDef stmtDef, ParsedStmt parsed) {
        ArrayList<String> spans = new ArrayList<String>();
        String statement = stmtDef.getStmt();
        HashSet<String> extraBindings = new HashSet<String>();
        extraBindings.addAll(stmtDef.getBindings().keySet());
        LinkedHashMap<String, String> specificBindings = new LinkedHashMap<String, String>();
        Matcher m = stmtToken.matcher(statement);
        int lastMatch = 0;
        String remainder = "";
        while (m.find(lastMatch)) {
            String pre = statement.substring(lastMatch, m.start());
            String form1 = m.group(1);
            String form2 = m.group(2);
            String tokenName = form1 != null && !form1.isEmpty() ? form1 : form2;
            lastMatch = m.end();
            spans.add(pre);
            if (!extraBindings.contains(tokenName)) continue;
            if (specificBindings.get(tokenName) != null) {
                String postfix = UUID.randomUUID().toString();
                specificBindings.put(tokenName + postfix, stmtDef.getBindings().get(tokenName));
                continue;
            }
            specificBindings.put(tokenName, stmtDef.getBindings().get(tokenName));
        }
        return specificBindings;
    }
}

