/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.core;

import com.codahale.metrics.Timer;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.internal.com_google_common.util.concurrent.ListenableFuture;
import io.nosqlbench.activitytype.cql.api.ResultSetCycleOperator;
import io.nosqlbench.activitytype.cql.api.RowCycleOperator;
import io.nosqlbench.activitytype.cql.api.StatementFilter;
import io.nosqlbench.activitytype.cql.core.CQLBindHelper;
import io.nosqlbench.activitytype.cql.core.CqlActivity;
import io.nosqlbench.activitytype.cql.core.StatementModifier;
import io.nosqlbench.activitytype.cql.errorhandling.ErrorStatus;
import io.nosqlbench.activitytype.cql.errorhandling.HashedCQLErrorHandler;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.CQLCycleWithStatementException;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.ChangeUnappliedCycleException;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.MaxTriesExhaustedException;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.UnexpectedPagingException;
import io.nosqlbench.activitytype.cql.statements.core.ReadyCQLStatement;
import io.nosqlbench.engine.api.activityapi.core.ActivityDefObserver;
import io.nosqlbench.engine.api.activityapi.core.MultiPhaseAction;
import io.nosqlbench.engine.api.activityapi.core.SyncAction;
import io.nosqlbench.engine.api.activityapi.planning.OpSequence;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlAction
implements SyncAction,
MultiPhaseAction,
ActivityDefObserver {
    private static final Logger logger = LoggerFactory.getLogger(CqlAction.class);
    private final int slot;
    private final CqlActivity cqlActivity;
    private final ActivityDef activityDef;
    private List<RowCycleOperator> rowOps;
    private List<ResultSetCycleOperator> cycleOps;
    private List<StatementModifier> modifiers;
    private StatementFilter statementFilter;
    private OpSequence<ReadyCQLStatement> sequencer;
    private int maxTries = 10;
    private HashedCQLErrorHandler ebdseErrorHandler;
    private int pagesFetched = 0;
    private long totalRowsFetchedForQuery = 0L;
    private ResultSet pagingResultSet;
    private Statement pagingStatement;
    private ReadyCQLStatement pagingReadyStatement;
    private boolean showcql;
    private long nanoStartTime;
    private long retryDelay;
    private long maxRetryDelay;
    private boolean retryReplace;

    public CqlAction(ActivityDef activityDef, int slot, CqlActivity cqlActivity) {
        this.activityDef = activityDef;
        this.cqlActivity = cqlActivity;
        this.slot = slot;
        this.onActivityDefUpdate(activityDef);
    }

    @Override
    public void init() {
        this.onActivityDefUpdate(this.activityDef);
        this.sequencer = this.cqlActivity.getOpSequencer();
    }

    @Override
    public int runCycle(long value) {
        return this.runPhase(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public int runPhase(long cycleValue) {
        HashedCQLErrorHandler.resetThreadStatusCode();
        if (this.pagingResultSet == null) {
            Statement statement;
            ReadyCQLStatement readyCQLStatement;
            this.totalRowsFetchedForQuery = 0L;
            int tries = 0;
            try (Timer.Context bindTime = this.cqlActivity.bindTimer.time();){
                readyCQLStatement = this.sequencer.get(cycleValue);
                statement = readyCQLStatement.bind(cycleValue);
                if (this.statementFilter != null && !this.statementFilter.matches(statement)) {
                    this.cqlActivity.skippedTokensHisto.update(cycleValue);
                    int n = 0;
                    return n;
                }
                if (this.modifiers != null) {
                    for (StatementModifier modifier : this.modifiers) {
                        statement = modifier.modify(statement, cycleValue);
                    }
                }
                if (this.showcql) {
                    logger.info("CQL(cycle=" + cycleValue + "):\n" + readyCQLStatement.getQueryString(cycleValue));
                }
            }
            this.nanoStartTime = System.nanoTime();
            while (tries < this.maxTries) {
                ResultSetFuture resultSetFuture;
                if (++tries > this.maxTries) {
                    throw new MaxTriesExhaustedException(cycleValue, this.maxTries);
                }
                if (tries > 1) {
                    try (Timer.Context retryTime2222 = this.cqlActivity.retryDelayTimer.time();){
                        Thread.sleep(Math.min((this.retryDelay << tries) / 1000L, this.maxRetryDelay / 1000L));
                    }
                    catch (InterruptedException retryTime2222) {
                        // empty catch block
                    }
                }
                try (Timer.Context executeTime = this.cqlActivity.executeTimer.time();){
                    resultSetFuture = this.cqlActivity.getSession().executeAsync(statement);
                }
                Timer.Context resultTime = this.cqlActivity.resultTimer.time();
                try {
                    int pageRows;
                    ResultSetCycleOperator[] perStmtRSOperators;
                    ResultSet resultSet = resultSetFuture.getUninterruptibly();
                    if (this.cycleOps != null) {
                        for (Object cycleOp : this.cycleOps) {
                            cycleOp.apply(resultSet, statement, cycleValue);
                        }
                    }
                    if ((perStmtRSOperators = readyCQLStatement.getResultSetOperators()) != null) {
                        for (Object perStmtRSOperator : perStmtRSOperators) {
                            perStmtRSOperator.apply(resultSet, statement, cycleValue);
                        }
                    }
                    if (!resultSet.wasApplied()) {
                        Row row = resultSet.one();
                        ColumnDefinitions defs = row.getColumnDefinitions();
                        if (this.retryReplace) {
                            statement = CQLBindHelper.rebindUnappliedStatement(statement, defs, row);
                        }
                        logger.trace(readyCQLStatement.getQueryString(cycleValue));
                        throw new ChangeUnappliedCycleException(cycleValue, resultSet, readyCQLStatement.getQueryString(cycleValue));
                    }
                    int remaining = pageRows = resultSet.getAvailableWithoutFetching();
                    RowCycleOperator[] perStmtRowOperators = readyCQLStatement.getRowCycleOperators();
                    if (this.rowOps == null && perStmtRowOperators == null) {
                        while (remaining-- > 0) {
                            Object perStmtRSOperator;
                            perStmtRSOperator = resultSet.one();
                        }
                    } else {
                        while (remaining-- > 0) {
                            Row onerow = resultSet.one();
                            if (this.rowOps != null) {
                                for (RowCycleOperator rowOp : this.rowOps) {
                                    rowOp.apply(onerow, cycleValue);
                                }
                            }
                            if (perStmtRowOperators == null) continue;
                            for (RowCycleOperator rowOp : perStmtRowOperators) {
                                rowOp.apply(onerow, cycleValue);
                            }
                        }
                    }
                    this.cqlActivity.rowsCounter.mark(pageRows);
                    this.totalRowsFetchedForQuery += (long)pageRows;
                    if (resultSet.isFullyFetched()) {
                        long resultNanos = System.nanoTime() - this.nanoStartTime;
                        this.cqlActivity.resultSuccessTimer.update(resultNanos, TimeUnit.NANOSECONDS);
                        this.cqlActivity.resultSetSizeHisto.update(this.totalRowsFetchedForQuery);
                        readyCQLStatement.onSuccess(cycleValue, resultNanos, this.totalRowsFetchedForQuery);
                        break;
                    }
                    if (this.cqlActivity.maxpages > 1) {
                        this.pagingResultSet = resultSet;
                        this.pagingStatement = statement;
                        this.pagingReadyStatement = readyCQLStatement;
                        this.pagesFetched = 1;
                        break;
                    }
                    throw new UnexpectedPagingException(cycleValue, resultSet, readyCQLStatement.getQueryString(cycleValue), 1, this.cqlActivity.maxpages, this.cqlActivity.getSession().getCluster().getConfiguration().getQueryOptions().getFetchSize());
                }
                catch (Exception e) {
                    long resultNanos = resultTime.stop();
                    resultTime = null;
                    readyCQLStatement.onError(cycleValue, resultNanos, e);
                    CQLCycleWithStatementException cqlCycleException = new CQLCycleWithStatementException(cycleValue, resultNanos, e, readyCQLStatement);
                    ErrorStatus errorStatus = (ErrorStatus)this.ebdseErrorHandler.handleError(cycleValue, cqlCycleException);
                    if (errorStatus.isRetryable()) continue;
                    this.cqlActivity.triesHisto.update(tries);
                    int n = errorStatus.getResultCode();
                    return n;
                }
                finally {
                    if (resultTime == null) continue;
                    resultTime.stop();
                }
            }
            this.cqlActivity.triesHisto.update(tries);
        } else {
            int tries = 0;
            while (tries < this.maxTries) {
                if (++tries > this.maxTries) {
                    throw new MaxTriesExhaustedException(cycleValue, this.maxTries);
                }
                Timer.Context pagingTime = this.cqlActivity.pagesTimer.time();
                try {
                    ListenableFuture pagingFuture;
                    try (Timer.Context executeTime = this.cqlActivity.executeTimer.time();){
                        pagingFuture = this.pagingResultSet.fetchMoreResults();
                    }
                    Timer.Context resultTime = this.cqlActivity.resultTimer.time();
                    try {
                        int pageRows;
                        ResultSetCycleOperator[] perStmtRSOperators;
                        ResultSet resultSet = (ResultSet)pagingFuture.get();
                        if (this.cycleOps != null) {
                            for (Object cycleOp : this.cycleOps) {
                                cycleOp.apply(resultSet, this.pagingStatement, cycleValue);
                            }
                        }
                        if ((perStmtRSOperators = this.pagingReadyStatement.getResultSetOperators()) != null) {
                            for (ResultSetCycleOperator perStmtRSOperator : perStmtRSOperators) {
                                perStmtRSOperator.apply(resultSet, this.pagingStatement, cycleValue);
                            }
                        }
                        ++this.pagesFetched;
                        int remaining = pageRows = resultSet.getAvailableWithoutFetching();
                        if (this.rowOps == null) {
                            while (remaining-- > 0) {
                                resultSet.one();
                            }
                        } else {
                            while (remaining-- > 0) {
                                for (RowCycleOperator rowOp : this.rowOps) {
                                    rowOp.apply(resultSet.one(), cycleValue);
                                }
                            }
                        }
                        this.cqlActivity.rowsCounter.mark(pageRows);
                        this.totalRowsFetchedForQuery += (long)pageRows;
                        if (resultSet.isFullyFetched()) {
                            long nanoTime = System.nanoTime() - this.nanoStartTime;
                            this.cqlActivity.resultSuccessTimer.update(nanoTime, TimeUnit.NANOSECONDS);
                            this.cqlActivity.resultSetSizeHisto.update(this.totalRowsFetchedForQuery);
                            this.pagingReadyStatement.onSuccess(cycleValue, nanoTime, this.totalRowsFetchedForQuery);
                            this.pagingResultSet = null;
                        } else {
                            if (this.pagesFetched > this.cqlActivity.maxpages) {
                                throw new UnexpectedPagingException(cycleValue, this.pagingResultSet, this.pagingReadyStatement.getQueryString(cycleValue), this.pagesFetched, this.cqlActivity.maxpages, this.cqlActivity.getSession().getCluster().getConfiguration().getQueryOptions().getFetchSize());
                            }
                            this.pagingResultSet = resultSet;
                        }
                        if (resultTime == null) break;
                        resultTime.stop();
                    }
                    catch (Exception e) {
                        block87: {
                            int n;
                            block88: {
                                long resultNanos = resultTime.stop();
                                resultTime = null;
                                this.pagingReadyStatement.onError(cycleValue, resultNanos, e);
                                CQLCycleWithStatementException cqlCycleException = new CQLCycleWithStatementException(cycleValue, resultNanos, e, this.pagingReadyStatement);
                                ErrorStatus errorStatus = (ErrorStatus)this.ebdseErrorHandler.handleError(cycleValue, cqlCycleException);
                                if (errorStatus.isRetryable()) break block87;
                                this.cqlActivity.triesHisto.update(tries);
                                n = errorStatus.getResultCode();
                                if (resultTime == null) break block88;
                                resultTime.stop();
                            }
                            if (pagingTime != null) {
                                pagingTime.close();
                            }
                            return n;
                        }
                        if (resultTime == null) continue;
                        resultTime.stop();
                        continue;
                        {
                            catch (Throwable throwable) {
                                if (resultTime != null) {
                                    resultTime.stop();
                                }
                                throw throwable;
                            }
                        }
                    }
                    break;
                }
                finally {
                    if (pagingTime == null) continue;
                    pagingTime.close();
                }
            }
            this.cqlActivity.triesHisto.update(tries);
        }
        return 0;
    }

    @Override
    public boolean incomplete() {
        return this.pagingResultSet != null;
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
        this.maxTries = this.cqlActivity.getMaxTries();
        this.retryDelay = this.cqlActivity.getRetryDelay();
        this.maxRetryDelay = this.cqlActivity.getMaxRetryDelay();
        this.retryReplace = this.cqlActivity.isRetryReplace();
        this.showcql = this.cqlActivity.isShowCql();
        this.ebdseErrorHandler = this.cqlActivity.getCqlErrorHandler();
        this.statementFilter = this.cqlActivity.getStatementFilter();
        this.rowOps = this.cqlActivity.getRowCycleOperators();
        this.cycleOps = this.cqlActivity.getResultSetCycleOperators();
        this.modifiers = this.cqlActivity.getStatementModifiers();
    }

    protected CqlActivity getCqlActivity() {
        return this.cqlActivity;
    }
}

