/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.core;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.TokenRangeStmtFilter;
import io.nosqlbench.activitytype.cql.api.ErrorResponse;
import io.nosqlbench.activitytype.cql.api.ResultSetCycleOperator;
import io.nosqlbench.activitytype.cql.api.RowCycleOperator;
import io.nosqlbench.activitytype.cql.api.StatementFilter;
import io.nosqlbench.activitytype.cql.codecsupport.UDTCodecInjector;
import io.nosqlbench.activitytype.cql.core.CQLOptions;
import io.nosqlbench.activitytype.cql.core.StatementModifier;
import io.nosqlbench.activitytype.cql.errorhandling.HashedCQLErrorHandler;
import io.nosqlbench.activitytype.cql.errorhandling.NBCycleErrorHandler;
import io.nosqlbench.activitytype.cql.statements.binders.CqlBinderTypes;
import io.nosqlbench.activitytype.cql.statements.core.AvailableCQLStatements;
import io.nosqlbench.activitytype.cql.statements.core.CQLSessionCache;
import io.nosqlbench.activitytype.cql.statements.core.CQLStatementDef;
import io.nosqlbench.activitytype.cql.statements.core.ReadyCQLStatement;
import io.nosqlbench.activitytype.cql.statements.core.ReadyCQLStatementTemplate;
import io.nosqlbench.activitytype.cql.statements.core.TaggedCQLStatementDefs;
import io.nosqlbench.activitytype.cql.statements.core.YamlCQLStatementLoader;
import io.nosqlbench.activitytype.cql.statements.rowoperators.RowCycleOperators;
import io.nosqlbench.activitytype.cql.statements.rowoperators.Save;
import io.nosqlbench.activitytype.cql.statements.rsoperators.ResultSetCycleOperators;
import io.nosqlbench.activitytype.cql.statements.rsoperators.TraceLogger;
import io.nosqlbench.engine.api.activityapi.core.Activity;
import io.nosqlbench.engine.api.activityapi.core.ActivityDefObserver;
import io.nosqlbench.engine.api.activityapi.planning.OpSequence;
import io.nosqlbench.engine.api.activityapi.planning.SequencePlanner;
import io.nosqlbench.engine.api.activityapi.planning.SequencerType;
import io.nosqlbench.engine.api.activityconfig.ParsedStmt;
import io.nosqlbench.engine.api.activityconfig.StatementsLoader;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtDef;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtsBlock;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtsDoc;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtsDocList;
import io.nosqlbench.engine.api.activityconfig.yaml.StmtDef;
import io.nosqlbench.engine.api.activityconfig.yaml.StmtsDocList;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.activityimpl.ParameterMap;
import io.nosqlbench.engine.api.activityimpl.SimpleActivity;
import io.nosqlbench.engine.api.metrics.ActivityMetrics;
import io.nosqlbench.engine.api.metrics.ExceptionCountMetrics;
import io.nosqlbench.engine.api.metrics.ExceptionHistoMetrics;
import io.nosqlbench.engine.api.templating.StrInterpolator;
import io.nosqlbench.engine.api.util.SimpleConfig;
import io.nosqlbench.engine.api.util.TagFilter;
import io.nosqlbench.engine.api.util.Unit;
import io.nosqlbench.nb.api.errors.BasicError;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlActivity
extends SimpleActivity
implements Activity,
ActivityDefObserver {
    private static final Logger logger = LoggerFactory.getLogger(CqlActivity.class);
    private final ExceptionCountMetrics exceptionCountMetrics;
    private final ExceptionHistoMetrics exceptionHistoMetrics;
    private final ActivityDef activityDef;
    private final Map<String, Writer> namedWriters = new HashMap<String, Writer>();
    protected List<StmtDef> stmts;
    Timer retryDelayTimer;
    Timer bindTimer;
    Timer executeTimer;
    Timer resultTimer;
    Timer resultSuccessTimer;
    Timer pagesTimer;
    Histogram triesHisto;
    Histogram skippedTokensHisto;
    Histogram resultSetSizeHisto;
    int maxpages;
    Meter rowsCounter;
    private HashedCQLErrorHandler errorHandler;
    private OpSequence<ReadyCQLStatement> opsequence;
    private Session session;
    private int maxTries;
    private StatementFilter statementFilter;
    private Boolean showcql;
    private List<RowCycleOperator> rowCycleOperators;
    private List<ResultSetCycleOperator> resultSetCycleOperators;
    private List<StatementModifier> statementModifiers;
    private Long maxTotalOpsInFlight;
    private long retryDelay;
    private long maxRetryDelay;
    private boolean retryReplace;
    private String pooling;

    public CqlActivity(ActivityDef activityDef) {
        super(activityDef);
        this.activityDef = activityDef;
        this.exceptionCountMetrics = new ExceptionCountMetrics(activityDef);
        this.exceptionHistoMetrics = new ExceptionHistoMetrics(activityDef);
    }

    private void registerCodecs(Session session) {
        UDTCodecInjector injector = new UDTCodecInjector();
        injector.injectUserProvidedCodecs(session, true);
    }

    @Override
    public synchronized void initActivity() {
        logger.debug("initializing activity: " + this.activityDef.getAlias());
        this.session = this.getSession();
        if (this.getParams().getOptionalBoolean("usercodecs").orElse(false).booleanValue()) {
            this.registerCodecs(this.session);
        }
        this.initSequencer();
        this.setDefaultsFromOpSequence(this.opsequence);
        this.retryDelayTimer = ActivityMetrics.timer(this.activityDef, "retry-delay");
        this.bindTimer = ActivityMetrics.timer(this.activityDef, "bind");
        this.executeTimer = ActivityMetrics.timer(this.activityDef, "execute");
        this.resultTimer = ActivityMetrics.timer(this.activityDef, "result");
        this.triesHisto = ActivityMetrics.histogram(this.activityDef, "tries");
        this.pagesTimer = ActivityMetrics.timer(this.activityDef, "pages");
        this.rowsCounter = ActivityMetrics.meter(this.activityDef, "rows");
        this.skippedTokensHisto = ActivityMetrics.histogram(this.activityDef, "skipped-tokens");
        this.resultSuccessTimer = ActivityMetrics.timer(this.activityDef, "result-success");
        this.resultSetSizeHisto = ActivityMetrics.histogram(this.activityDef, "resultset-size");
        this.onActivityDefUpdate(this.activityDef);
        logger.debug("activity fully initialized: " + this.activityDef.getAlias());
    }

    public synchronized Session getSession() {
        if (this.session == null) {
            this.session = CQLSessionCache.get().getSession(this.getActivityDef());
        }
        return this.session;
    }

    private void initSequencer() {
        Session session = this.getSession();
        Map<String, Object> fconfig = Map.of("cluster", session.getCluster());
        SequencerType sequencerType = SequencerType.valueOf(this.getParams().getOptionalString("seq").orElse("bucket"));
        SequencePlanner<ReadyCQLStatement> planner = new SequencePlanner<ReadyCQLStatement>(sequencerType);
        StmtsDocList unfiltered = this.loadStmtsYaml();
        String tagfilter = this.activityDef.getParams().getOptionalString("tags").orElse("");
        TagFilter tagFilter = new TagFilter(tagfilter);
        unfiltered.getStmts().stream().map(tagFilter::matchesTaggedResult).forEach(r -> logger.info(r.getLog()));
        this.stmts = unfiltered.getStmts(tagfilter);
        if (this.stmts.size() == 0) {
            throw new RuntimeException("There were no unfiltered statements found for this activity.");
        }
        for (StmtDef stmtDef : this.stmts) {
            ReadyCQLStatementTemplate template;
            ParsedStmt parsed = stmtDef.getParsed().orError();
            boolean prepared = Boolean.valueOf(stmtDef.getParams().getOrDefault("prepared", "true"));
            boolean parametrized = Boolean.valueOf(stmtDef.getParams().getOrDefault("parametrized", "false"));
            long ratio = Long.valueOf(stmtDef.getParams().getOrDefault("ratio", "1"));
            Optional<ConsistencyLevel> cl = Optional.ofNullable(stmtDef.getParams().getOrDefault("cl", null)).map(ConsistencyLevel::valueOf);
            Optional<ConsistencyLevel> serial_cl = Optional.ofNullable(stmtDef.getParams().getOrDefault("serial_cl", null)).map(ConsistencyLevel::valueOf);
            Optional<Boolean> idempotent = Optional.ofNullable(stmtDef.getParams().getOrDefault("idempotent", null)).map(Boolean::valueOf);
            StringBuilder psummary = new StringBuilder();
            boolean instrument = Optional.ofNullable(stmtDef.getParams().get("instrument")).map(Boolean::valueOf).orElse(this.getParams().getOptionalBoolean("instrument").orElse(false));
            String logresultcsv = stmtDef.getParams().getOrDefault("logresultcsv", "");
            String logresultcsv_act = this.getParams().getOptionalString("logresultcsv").orElse("");
            if (!logresultcsv_act.isEmpty() && !logresultcsv_act.toLowerCase().equals("true")) {
                throw new RuntimeException("At the activity level, only logresultcsv=true is allowed, no other values.");
            }
            logresultcsv = !logresultcsv.isEmpty() ? logresultcsv : logresultcsv_act;
            logresultcsv = !logresultcsv.toLowerCase().equals("true") ? logresultcsv : stmtDef.getName() + "--results.csv";
            logger.debug("readying statement[" + (prepared ? "" : "un") + "prepared]:" + parsed.getStmt());
            String stmtForDriver = parsed.getPositionalStatement(s -> "?");
            if (prepared) {
                psummary.append(" prepared=>").append(prepared);
                PreparedStatement prepare = this.getSession().prepare(stmtForDriver);
                cl.ifPresent(conlvl -> {
                    psummary.append(" consistency_level=>").append(conlvl);
                    prepare.setConsistencyLevel((ConsistencyLevel)((Object)conlvl));
                });
                serial_cl.ifPresent(scl -> {
                    psummary.append(" serial_consistency_level=>").append(serial_cl);
                    prepare.setSerialConsistencyLevel((ConsistencyLevel)((Object)scl));
                });
                idempotent.ifPresent(i -> {
                    psummary.append(" idempotent=").append(idempotent);
                    prepare.setIdempotent((Boolean)i);
                });
                CqlBinderTypes binderType = CqlBinderTypes.valueOf(stmtDef.getParams().getOrDefault("binder", CqlBinderTypes.DEFAULT.toString()));
                template = new ReadyCQLStatementTemplate(fconfig, binderType, this.getSession(), prepare, ratio, parsed.getName());
            } else {
                SimpleStatement simpleStatement = new SimpleStatement(stmtForDriver);
                cl.ifPresent(conlvl -> {
                    psummary.append(" consistency_level=>").append(conlvl);
                    simpleStatement.setConsistencyLevel((ConsistencyLevel)((Object)conlvl));
                });
                serial_cl.ifPresent(scl -> {
                    psummary.append(" serial_consistency_level=>").append(scl);
                    simpleStatement.setSerialConsistencyLevel((ConsistencyLevel)((Object)scl));
                });
                idempotent.ifPresent(i -> {
                    psummary.append(" idempotent=>").append(i);
                    simpleStatement.setIdempotent((boolean)i);
                });
                template = new ReadyCQLStatementTemplate(fconfig, this.getSession(), simpleStatement, ratio, parsed.getName(), parametrized);
            }
            Optional.ofNullable(stmtDef.getParams().getOrDefault("save", null)).map(s -> s.split("[,; ]")).map(Save::new).ifPresent(save_op -> {
                psummary.append(" save=>").append(save_op.toString());
                template.addRowCycleOperators((RowCycleOperator)save_op);
            });
            Optional.ofNullable(stmtDef.getParams().getOrDefault("rsoperators", null)).map(s -> s.split(",")).stream().flatMap(Arrays::stream).map(ResultSetCycleOperators::newOperator).forEach(rso -> {
                psummary.append(" rsop=>").append(rso.toString());
                template.addResultSetOperators((ResultSetCycleOperator)rso);
            });
            Optional.ofNullable(stmtDef.getParams().getOrDefault("rowoperators", null)).map(s -> s.split(",")).stream().flatMap(Arrays::stream).map(RowCycleOperators::newOperator).forEach(ro -> {
                psummary.append(" rowop=>").append(ro.toString());
                template.addRowCycleOperators((RowCycleOperator)ro);
            });
            if (instrument) {
                logger.info("Adding per-statement success and error and resultset-size timers to statement '" + parsed.getName() + "'");
                template.instrument(this);
                psummary.append(" instrument=>").append(instrument);
            }
            if (!logresultcsv.isEmpty()) {
                logger.info("Adding per-statement result CSV logging to statement '" + parsed.getName() + "'");
                template.logResultCsv(this, logresultcsv);
                psummary.append(" logresultcsv=>").append(logresultcsv);
            }
            template.getContextualBindings().getBindingsTemplate().addFieldBindings(stmtDef.getParsed().getBindPoints());
            if (psummary.length() > 0) {
                logger.info("statement named '" + stmtDef.getName() + "' has custom settings:" + psummary.toString());
            }
            planner.addOp(template.resolve(), ratio);
        }
        this.opsequence = planner.resolve();
    }

    private StmtsDocList loadStmtsYaml() {
        StmtsDocList doclist = null;
        String yaml_loc = this.activityDef.getParams().getOptionalString("yaml", "workload").orElse("default");
        StrInterpolator interp = new StrInterpolator(this.activityDef);
        String yamlVersion = "unset";
        if (yaml_loc.endsWith(":1") || yaml_loc.endsWith(":2")) {
            yamlVersion = yaml_loc.substring(yaml_loc.length() - 1);
            yaml_loc = yaml_loc.substring(0, yaml_loc.length() - 2);
        }
        switch (yamlVersion) {
            case "1": {
                doclist = this.getVersion1StmtsDoc(interp, yaml_loc);
                logger.warn("DEPRECATED-FORMAT: Loaded yaml " + yaml_loc + " with compatibility mode. This will be deprecated in a future release.");
                logger.warn("DEPRECATED-FORMAT: Please refer to http://docs.engineblock.io/user-guide/standard_yaml/ for more details.");
                break;
            }
            case "2": {
                doclist = StatementsLoader.load(logger, yaml_loc, interp, "activities");
                break;
            }
            case "unset": {
                try {
                    logger.debug("You can suffix your yaml filename or url with the format version, such as :1 or :2. Assuming version 2.");
                    doclist = StatementsLoader.load(null, yaml_loc, interp, "activities");
                }
                catch (Exception ignored) {
                    try {
                        doclist = this.getVersion1StmtsDoc(interp, yaml_loc);
                        logger.warn("DEPRECATED-FORMAT: Loaded yaml " + yaml_loc + " with compatibility mode. This will be deprecated in a future release.");
                        logger.warn("DEPRECATED-FORMAT: Please refer to http://docs.engineblock.io/user-guide/standard_yaml/ for more details.");
                    }
                    catch (Exception compatError) {
                        logger.warn("Tried to load yaml in compatibility mode, since it failed to load with the standard format, but found an error:" + compatError);
                        logger.warn("The following detailed errors are provided only for the standard format. To force loading version 1 with detailed logging, add a version qualifier to your yaml filename or url like ':1'");
                        doclist = StatementsLoader.load(logger, yaml_loc, interp, "activities");
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized yaml format version, expected :1 or :2 at end of yaml file, but got " + yamlVersion + " instead.");
            }
        }
        return doclist;
    }

    @Deprecated
    private StmtsDocList getVersion1StmtsDoc(StrInterpolator interp, String yaml_loc) {
        ArrayList<RawStmtsBlock> blocks = new ArrayList<RawStmtsBlock>();
        YamlCQLStatementLoader deprecatedLoader = new YamlCQLStatementLoader(interp);
        AvailableCQLStatements rawDocs = deprecatedLoader.load(yaml_loc, "activities");
        List<TaggedCQLStatementDefs> rawTagged = rawDocs.getRawTagged();
        for (TaggedCQLStatementDefs rawdef : rawTagged) {
            for (CQLStatementDef rawstmt : rawdef.getStatements()) {
                RawStmtsBlock rawblock = new RawStmtsBlock();
                rawblock.setTags(rawdef.getTags());
                HashMap<String, String> params = new HashMap<String, String>(rawdef.getParams());
                if (rawstmt.getConsistencyLevel() != null && !rawstmt.getConsistencyLevel().isEmpty()) {
                    params.put("cl", rawstmt.getConsistencyLevel());
                }
                if (!rawstmt.isPrepared()) {
                    params.put("prepared", "false");
                }
                if (rawstmt.getRatio() != 1L) {
                    params.put("ratio", String.valueOf(rawstmt.getRatio()));
                }
                rawblock.setParams(params);
                ArrayList<RawStmtDef> stmtslist = new ArrayList<RawStmtDef>();
                stmtslist.add(new RawStmtDef(rawstmt.getName(), rawstmt.getStatement()));
                rawblock.setRawStmtDefs(stmtslist);
                rawblock.setBindings(rawstmt.getBindings());
                blocks.add(rawblock);
            }
        }
        RawStmtsDoc rawStmtsDoc = new RawStmtsDoc();
        rawStmtsDoc.setBlocks(blocks);
        ArrayList<RawStmtsDoc> rawStmtsDocs = new ArrayList<RawStmtsDoc>();
        rawStmtsDocs.add(rawStmtsDoc);
        RawStmtsDocList rawStmtsDocList = new RawStmtsDocList(rawStmtsDocs);
        StmtsDocList unfiltered = new StmtsDocList(rawStmtsDocList);
        return unfiltered;
    }

    public ExceptionCountMetrics getExceptionCountMetrics() {
        return this.exceptionCountMetrics;
    }

    @Override
    public String toString() {
        return "CQLActivity {activityDef=" + this.activityDef + ", session=" + this.session + ", opSequence=" + this.opsequence + "}";
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
        super.onActivityDefUpdate(activityDef);
        this.clearResultSetCycleOperators();
        this.clearRowCycleOperators();
        this.clearStatementModifiers();
        ParameterMap params = activityDef.getParams();
        Optional<String> fetchSizeOption = params.getOptionalString("fetchsize");
        Cluster cluster = this.getSession().getCluster();
        if (fetchSizeOption.isPresent()) {
            int fetchSize = fetchSizeOption.flatMap(Unit::bytesFor).map(Double::intValue).orElseThrow(() -> new RuntimeException("Unable to parse fetch size from " + (String)fetchSizeOption.get()));
            if (fetchSize > 10000000 && fetchSize < 1000000000) {
                logger.warn("Setting the fetchsize to " + fetchSize + " is unlikely to give good performance.");
            } else if (fetchSize > 1000000000) {
                throw new RuntimeException("Setting the fetch size to " + fetchSize + " is likely to cause instability.");
            }
            logger.trace("setting fetchSize to " + fetchSize);
            cluster.getConfiguration().getQueryOptions().setFetchSize(fetchSize);
        }
        this.retryDelay = params.getOptionalLong("retrydelay").orElse(0L);
        this.maxRetryDelay = params.getOptionalLong("maxretrydelay").orElse(500L);
        this.retryReplace = params.getOptionalBoolean("retryreplace").orElse(false);
        this.maxTries = params.getOptionalInteger("maxtries").orElse(10);
        this.showcql = params.getOptionalBoolean("showcql").orElse(false);
        this.maxpages = params.getOptionalInteger("maxpages").orElse(1);
        this.statementFilter = params.getOptionalString("tokens").map(s -> new TokenRangeStmtFilter(cluster, (String)s)).orElse(null);
        if (this.statementFilter != null) {
            logger.info("filtering statements" + this.statementFilter);
        }
        this.errorHandler = this.configureErrorHandler();
        params.getOptionalString("trace").map(SimpleConfig::new).map(TraceLogger::new).ifPresent(tl -> {
            this.addResultSetCycleOperator((ResultSetCycleOperator)tl);
            this.addStatementModifier((StatementModifier)tl);
        });
        this.maxTotalOpsInFlight = params.getOptionalLong("async").orElse(1L);
        Optional<String> dynpooling = params.getOptionalString("pooling");
        if (dynpooling.isPresent()) {
            logger.info("dynamically updating pooling");
            if (!dynpooling.get().equals(this.pooling)) {
                PoolingOptions opts = CQLOptions.poolingOptionsFor(dynpooling.get());
                logger.info("pooling=>" + dynpooling.get());
                PoolingOptions cfg = this.getSession().getCluster().getConfiguration().getPoolingOptions();
                int prior_mcph_l = cfg.getMaxConnectionsPerHost(HostDistance.LOCAL);
                int mcph_l = opts.getMaxConnectionsPerHost(HostDistance.LOCAL);
                int ccph_l = opts.getCoreConnectionsPerHost(HostDistance.LOCAL);
                if (prior_mcph_l < mcph_l) {
                    logger.info("setting mcph_l to " + mcph_l);
                    cfg.setMaxConnectionsPerHost(HostDistance.LOCAL, mcph_l);
                }
                logger.info("setting ccph_l to " + ccph_l);
                cfg.setCoreConnectionsPerHost(HostDistance.LOCAL, ccph_l);
                if (mcph_l < prior_mcph_l) {
                    logger.info("setting mcph_l to " + mcph_l);
                    cfg.setMaxRequestsPerConnection(HostDistance.LOCAL, mcph_l);
                }
                cfg.setMaxRequestsPerConnection(HostDistance.LOCAL, opts.getMaxRequestsPerConnection(HostDistance.LOCAL));
                int prior_mcph_r = cfg.getMaxConnectionsPerHost(HostDistance.REMOTE);
                int mcph_r = opts.getMaxConnectionsPerHost(HostDistance.REMOTE);
                int ccph_r = opts.getCoreConnectionsPerHost(HostDistance.REMOTE);
                if (mcph_r > 0) {
                    if (mcph_r > prior_mcph_r) {
                        opts.setMaxConnectionsPerHost(HostDistance.REMOTE, mcph_r);
                    }
                    opts.setCoreConnectionsPerHost(HostDistance.REMOTE, ccph_r);
                    if (prior_mcph_r > mcph_r) {
                        opts.setMaxConnectionsPerHost(HostDistance.REMOTE, mcph_r);
                    }
                    if (opts.getMaxConnectionsPerHost(HostDistance.REMOTE) > 0) {
                        cfg.setMaxRequestsPerConnection(HostDistance.REMOTE, opts.getMaxRequestsPerConnection(HostDistance.REMOTE));
                    }
                }
                this.pooling = dynpooling.get();
            }
        }
    }

    private HashedCQLErrorHandler configureErrorHandler() {
        String[] handlerSpecs;
        HashedCQLErrorHandler newerrorHandler = new HashedCQLErrorHandler(this.exceptionCountMetrics);
        String errors = this.activityDef.getParams().getOptionalString("errors").orElse("stop,retryable->retry,unverified->stop");
        for (String spec : handlerSpecs = errors.split(",")) {
            NBCycleErrorHandler handler;
            ErrorResponse errorResponse;
            String[] keyval = spec.split("=|->|:", 2);
            if (keyval.length == 1) {
                String verb = keyval[0];
                ErrorResponse errorResponse2 = this.getErrorResponseOrBasicError(verb);
                newerrorHandler.setDefaultHandler(new NBCycleErrorHandler(errorResponse2, this.exceptionCountMetrics, this.exceptionHistoMetrics, !this.getParams().getOptionalLong("async").isPresent()));
                continue;
            }
            String pattern = keyval[0];
            String verb = keyval[1];
            if (newerrorHandler.getGroupNames().contains(pattern)) {
                errorResponse = this.getErrorResponseOrBasicError(verb);
                handler = new NBCycleErrorHandler(errorResponse, this.exceptionCountMetrics, this.exceptionHistoMetrics, !this.getParams().getOptionalLong("async").isPresent());
                logger.info("Handling error group '" + pattern + "' with handler:" + handler);
                newerrorHandler.setHandlerForGroup(pattern, handler);
                continue;
            }
            errorResponse = ErrorResponse.valueOf(keyval[1]);
            handler = new NBCycleErrorHandler(errorResponse, this.exceptionCountMetrics, this.exceptionHistoMetrics, !this.getParams().getOptionalLong("async").isPresent());
            logger.info("Handling error pattern '" + pattern + "' with handler:" + handler);
            newerrorHandler.setHandlerForPattern(keyval[0], handler);
        }
        return newerrorHandler;
    }

    private ErrorResponse getErrorResponseOrBasicError(String verb) {
        try {
            return ErrorResponse.valueOf(verb);
        }
        catch (IllegalArgumentException e) {
            throw new BasicError("Invalid parameter for errors: '" + verb + "' should be one of: " + StringUtils.join((Object[])ErrorResponse.values(), ", "));
        }
    }

    public int getMaxTries() {
        return this.maxTries;
    }

    public HashedCQLErrorHandler getCqlErrorHandler() {
        return this.errorHandler;
    }

    public StatementFilter getStatementFilter() {
        return this.statementFilter;
    }

    public void setStatementFilter(StatementFilter statementFilter) {
        this.statementFilter = statementFilter;
    }

    public Boolean isShowCql() {
        return this.showcql;
    }

    public OpSequence<ReadyCQLStatement> getOpSequencer() {
        return this.opsequence;
    }

    public List<RowCycleOperator> getRowCycleOperators() {
        return this.rowCycleOperators;
    }

    protected synchronized void addRowCycleOperator(RowCycleOperator rsOperator) {
        if (this.rowCycleOperators == null) {
            this.rowCycleOperators = new ArrayList<RowCycleOperator>();
        }
        this.rowCycleOperators.add(rsOperator);
    }

    private void clearRowCycleOperators() {
        this.rowCycleOperators = null;
    }

    public List<ResultSetCycleOperator> getResultSetCycleOperators() {
        return this.resultSetCycleOperators;
    }

    protected synchronized void addResultSetCycleOperator(ResultSetCycleOperator resultSetCycleOperator) {
        if (this.resultSetCycleOperators == null) {
            this.resultSetCycleOperators = new ArrayList<ResultSetCycleOperator>();
        }
        this.resultSetCycleOperators.add(resultSetCycleOperator);
    }

    private void clearResultSetCycleOperators() {
        this.resultSetCycleOperators = null;
    }

    public List<StatementModifier> getStatementModifiers() {
        return this.statementModifiers;
    }

    protected synchronized void addStatementModifier(StatementModifier modifier) {
        if (this.statementModifiers == null) {
            this.statementModifiers = new ArrayList<StatementModifier>();
        }
        this.statementModifiers.add(modifier);
    }

    private void clearStatementModifiers() {
        this.statementModifiers = null;
    }

    public long getMaxOpsInFlight(int slot) {
        int threads = this.getActivityDef().getThreads();
        return this.maxTotalOpsInFlight / (long)threads + (long)((long)slot < this.maxTotalOpsInFlight % (long)threads ? 1 : 0);
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public long getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    public void setMaxRetryDelay(long maxRetryDelay) {
        this.maxRetryDelay = maxRetryDelay;
    }

    public boolean isRetryReplace() {
        return this.retryReplace;
    }

    public void setRetryReplace(boolean retryReplace) {
        this.retryReplace = retryReplace;
    }

    public synchronized Writer getNamedWriter(String name) {
        Writer writer = this.namedWriters.computeIfAbsent(name, s -> {
            try {
                return new FileWriter(name, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        this.registerAutoCloseable(writer);
        return writer;
    }
}

