/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.core;

import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import io.nosqlbench.activitytype.cql.core.CqlActionDispenser;
import io.nosqlbench.activitytype.cql.core.CqlActivity;
import io.nosqlbench.engine.api.activityapi.core.ActionDispenser;
import io.nosqlbench.engine.api.activityapi.core.ActivityType;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.nb.annotations.Service;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

@Service(value=ActivityType.class)
public class CqlActivityType
implements ActivityType<CqlActivity> {
    @Override
    public String getName() {
        return "cql";
    }

    @Override
    public CqlActivity getActivity(ActivityDef activityDef) {
        Optional<String> yaml = activityDef.getParams().getOptionalString("yaml", "workload");
        if (yaml.isEmpty()) {
            throw new RuntimeException("Currently, the cql activity type requires yaml/workload activity parameter.");
        }
        if (activityDef.getAlias().equals("ALIAS_UNSET")) {
            activityDef.getParams().set("alias", yaml.get());
        }
        return new CqlActivity(activityDef);
    }

    @Override
    public ActionDispenser getActionDispenser(CqlActivity activity) {
        return new CqlActionDispenser(activity);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        LinkedHashMap typemap = new LinkedHashMap();
        typemap.put("ascii", String.class);
        typemap.put("bigint", Long.TYPE);
        typemap.put("blob", ByteBuffer.class);
        typemap.put("boolean", Boolean.TYPE);
        typemap.put("counter", Long.TYPE);
        typemap.put("date", LocalDate.class);
        typemap.put("decimal", BigDecimal.class);
        typemap.put("double", Double.TYPE);
        typemap.put("float", Float.TYPE);
        typemap.put("inet", InetAddress.class);
        typemap.put("int", Integer.TYPE);
        typemap.put("list", List.class);
        typemap.put("map", Map.class);
        typemap.put("set", Set.class);
        typemap.put("smallint", Short.TYPE);
        typemap.put("text", String.class);
        typemap.put("time", LocalTime.class);
        typemap.put("timestamp", Instant.class);
        typemap.put("tinyint", Byte.TYPE);
        typemap.put("tuple", TupleValue.class);
        typemap.put("<udt>", UDTValue.class);
        typemap.put("uuid", UUID.class);
        typemap.put("timeuuid", UUID.class);
        typemap.put("varchar", String.class);
        typemap.put("varint", BigInteger.class);
        return typemap;
    }
}

