/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.core;

import com.codahale.metrics.Timer;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.internal.com_google_common.util.concurrent.Futures;
import com.datastax.internal.com_google_common.util.concurrent.ListenableFuture;
import io.nosqlbench.activitytype.cql.api.ErrorResponse;
import io.nosqlbench.activitytype.cql.api.ResultSetCycleOperator;
import io.nosqlbench.activitytype.cql.api.RowCycleOperator;
import io.nosqlbench.activitytype.cql.api.StatementFilter;
import io.nosqlbench.activitytype.cql.core.CqlActivity;
import io.nosqlbench.activitytype.cql.core.CqlOpData;
import io.nosqlbench.activitytype.cql.core.StatementModifier;
import io.nosqlbench.activitytype.cql.errorhandling.ErrorStatus;
import io.nosqlbench.activitytype.cql.errorhandling.HashedCQLErrorHandler;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.CQLCycleWithStatementException;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.ChangeUnappliedCycleException;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.UnexpectedPagingException;
import io.nosqlbench.activitytype.cql.statements.core.ReadyCQLStatement;
import io.nosqlbench.engine.api.activityapi.core.BaseAsyncAction;
import io.nosqlbench.engine.api.activityapi.core.ops.fluent.opfacets.FailedOp;
import io.nosqlbench.engine.api.activityapi.core.ops.fluent.opfacets.StartedOp;
import io.nosqlbench.engine.api.activityapi.core.ops.fluent.opfacets.SucceededOp;
import io.nosqlbench.engine.api.activityapi.core.ops.fluent.opfacets.TrackedOp;
import io.nosqlbench.engine.api.activityapi.planning.OpSequence;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlAsyncAction
extends BaseAsyncAction<CqlOpData, CqlActivity> {
    private static final Logger logger = LoggerFactory.getLogger(CqlAsyncAction.class);
    private final ActivityDef activityDef;
    private List<RowCycleOperator> rowOps;
    private List<ResultSetCycleOperator> cycleOps;
    private List<StatementModifier> modifiers;
    private StatementFilter statementFilter;
    private OpSequence<ReadyCQLStatement> sequencer;
    private int maxTries = 10;
    private HashedCQLErrorHandler cqlActivityErrorHandler;
    private boolean showcql;

    public CqlAsyncAction(CqlActivity activity, int slot) {
        super(activity, slot);
        this.onActivityDefUpdate(activity.getActivityDef());
        this.activityDef = activity.getActivityDef();
    }

    @Override
    public void init() {
        this.onActivityDefUpdate(this.activityDef);
        this.sequencer = ((CqlActivity)this.activity).getOpSequencer();
    }

    @Override
    public LongFunction<CqlOpData> getOpInitFunction() {
        return l -> new CqlOpData(l, this);
    }

    @Override
    public void startOpCycle(TrackedOp<CqlOpData> opc) {
        CqlOpData cqlop = (CqlOpData)opc.getData();
        long cycle = opc.getCycle();
        try (Timer.Context bindTime = ((CqlActivity)this.activity).bindTimer.time();){
            cqlop.readyCQLStatement = this.sequencer.get(cycle);
            cqlop.statement = cqlop.readyCQLStatement.bind(cycle);
            if (this.statementFilter != null && !this.statementFilter.matches(cqlop.statement)) {
                ((CqlActivity)this.activity).skippedTokensHisto.update(cycle);
                cqlop.skipped = true;
                opc.skip(0);
                return;
            }
            if (this.modifiers != null) {
                for (StatementModifier modifier : this.modifiers) {
                    cqlop.statement = modifier.modify(cqlop.statement, cycle);
                }
            }
            if (this.showcql) {
                logger.info("CQL(cycle=" + cycle + "):\n" + cqlop.readyCQLStatement.getQueryString(cycle));
            }
        }
        StartedOp<CqlOpData> startedOp = opc.start();
        cqlop.startedOp = startedOp;
        try (Timer.Context executeTime = ((CqlActivity)this.activity).executeTimer.time();){
            cqlop.future = ((CqlActivity)this.activity).getSession().executeAsync(cqlop.statement);
            Futures.addCallback(cqlop.future, cqlop);
        }
    }

    public void onSuccess(StartedOp<CqlOpData> sop) {
        block14: {
            CqlOpData cqlop = (CqlOpData)sop.getData();
            HashedCQLErrorHandler.resetThreadStatusCode();
            if (cqlop.skipped) {
                return;
            }
            try {
                int pageRows;
                ResultSet resultSet = cqlop.resultSet;
                ++cqlop.totalPagesFetchedForQuery;
                if (this.cycleOps != null) {
                    for (ResultSetCycleOperator cycleOp : this.cycleOps) {
                        cycleOp.apply(resultSet, cqlop.statement, cqlop.cycle);
                    }
                }
                int remaining = pageRows = resultSet.getAvailableWithoutFetching();
                if (this.rowOps == null) {
                    while (remaining-- > 0) {
                        resultSet.one();
                    }
                } else {
                    while (remaining-- > 0) {
                        for (RowCycleOperator rowOp : this.rowOps) {
                            rowOp.apply(resultSet.one(), cqlop.cycle);
                        }
                    }
                }
                cqlop.totalRowsFetchedForQuery += (long)pageRows;
                if (cqlop.totalPagesFetchedForQuery++ > (long)((CqlActivity)this.activity).maxpages) {
                    throw new UnexpectedPagingException(cqlop.cycle, resultSet, cqlop.readyCQLStatement.getQueryString(cqlop.cycle), 1, ((CqlActivity)this.activity).maxpages, ((CqlActivity)this.activity).getSession().getCluster().getConfiguration().getQueryOptions().getFetchSize());
                }
                if (!resultSet.wasApplied()) {
                    throw new ChangeUnappliedCycleException(cqlop.cycle, resultSet, cqlop.readyCQLStatement.getQueryString(cqlop.cycle));
                }
                if (!resultSet.isFullyFetched()) {
                    logger.trace("async paging request " + cqlop.totalPagesFetchedForQuery + " for cycle " + cqlop.cycle);
                    ListenableFuture resultSetListenableFuture = resultSet.fetchMoreResults();
                    Futures.addCallback(resultSetListenableFuture, cqlop);
                    return;
                }
                SucceededOp<CqlOpData> success = sop.succeed(0);
                cqlop.readyCQLStatement.onSuccess(cqlop.cycle, success.getServiceTimeNanos(), cqlop.totalRowsFetchedForQuery);
                ((CqlActivity)this.activity).triesHisto.update(cqlop.triesAttempted);
                ((CqlActivity)this.activity).rowsCounter.mark(cqlop.totalRowsFetchedForQuery);
                ((CqlActivity)this.activity).resultSuccessTimer.update(success.getServiceTimeNanos(), TimeUnit.NANOSECONDS);
                ((CqlActivity)this.activity).resultSetSizeHisto.update(cqlop.totalRowsFetchedForQuery);
                ((CqlActivity)this.activity).resultTimer.update(success.getServiceTimeNanos(), TimeUnit.NANOSECONDS);
            }
            catch (Exception e) {
                long currentServiceTime = sop.getCurrentServiceTimeNanos();
                cqlop.readyCQLStatement.onError(cqlop.cycle, currentServiceTime, e);
                CQLCycleWithStatementException cqlCycleException = new CQLCycleWithStatementException(cqlop.cycle, currentServiceTime, e, cqlop.readyCQLStatement);
                ErrorStatus errorStatus = (ErrorStatus)this.cqlActivityErrorHandler.handleError(cqlop.cycle, cqlCycleException);
                if (errorStatus.isRetryable() && ++cqlop.triesAttempted < this.maxTries) {
                    ResultSetFuture resultSetFuture = ((CqlActivity)this.activity).getSession().executeAsync(cqlop.statement);
                    sop.retry();
                    Futures.addCallback(resultSetFuture, cqlop);
                    return;
                }
                sop.fail(errorStatus.getResultCode());
                if (errorStatus.getResponse() != ErrorResponse.stop) break block14;
                cqlop.throwable = cqlCycleException;
                ((CqlActivity)this.activity).getActivityController().stopActivityWithErrorAsync(cqlCycleException);
            }
        }
    }

    public void onFailure(StartedOp<CqlOpData> startedOp) {
        CqlOpData cqlop = (CqlOpData)startedOp.getData();
        long serviceTime = startedOp.getCurrentServiceTimeNanos();
        cqlop.readyCQLStatement.onError(startedOp.getCycle(), serviceTime, cqlop.throwable);
        long cycle = startedOp.getCycle();
        CQLCycleWithStatementException cqlCycleException1 = new CQLCycleWithStatementException(cqlop.cycle, serviceTime, cqlop.throwable, cqlop.readyCQLStatement);
        ErrorStatus errorStatus = (ErrorStatus)this.cqlActivityErrorHandler.handleError(startedOp.getCycle(), cqlCycleException1);
        if (errorStatus.getResponse() == ErrorResponse.stop) {
            ((CqlActivity)this.activity).getActivityController().stopActivityWithErrorAsync(cqlop.throwable);
            return;
        }
        if (errorStatus.isRetryable() && cqlop.triesAttempted < this.maxTries) {
            startedOp.retry();
            try (Timer.Context executeTime = ((CqlActivity)this.activity).executeTimer.time();){
                cqlop.future = ((CqlActivity)this.activity).getSession().executeAsync(cqlop.statement);
                Futures.addCallback(cqlop.future, cqlop);
                return;
            }
        }
        FailedOp<CqlOpData> failed = startedOp.fail(errorStatus.getResultCode());
        ((CqlActivity)this.activity).resultTimer.update(failed.getServiceTimeNanos(), TimeUnit.NANOSECONDS);
        ((CqlActivity)this.activity).triesHisto.update(cqlop.triesAttempted);
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
        this.maxTries = ((CqlActivity)this.activity).getMaxTries();
        this.showcql = ((CqlActivity)this.activity).isShowCql();
        this.cqlActivityErrorHandler = ((CqlActivity)this.activity).getCqlErrorHandler();
        this.statementFilter = ((CqlActivity)this.activity).getStatementFilter();
        this.rowOps = ((CqlActivity)this.activity).getRowCycleOperators();
        this.cycleOps = ((CqlActivity)this.activity).getResultSetCycleOperators();
        this.modifiers = ((CqlActivity)this.activity).getStatementModifiers();
    }

    public String toString() {
        return "CqlAsyncAction[" + this.slot + "]";
    }
}

