/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.datamappers.functions.collectionclobs;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class StringMapClob
implements LongFunction<String> {
    private static final ThreadLocal<StringBuilder> tl_sb = ThreadLocal.withInitial(StringBuilder::new);
    private final LongToIntFunction sizeFunc;
    private final LongFunction[] keyFuncs;
    private final LongFunction[] valueFuncs;
    private final Mode mode;
    private static final String BEFORE_RESULT = "{";
    private static final String AFTER_RESULT = "}";
    private static final String KEY_QUOTE = "'";
    private static final String VAL_QUOTE = "'";
    private static final String ASSIGNMENT = ": ";
    private static final String BETWEEN_ENTRIES = ", ";

    @Example(value={"StringMap(HashRange(3,7),NumberNameToString(),HashRange(1300,1700))", "create a map of size 3-7 entries, with a key of type string and a value of type int (Integer by autoboxing)"})
    public StringMapClob(LongToIntFunction sizeFunc, LongFunction<Object> keyFunc, LongFunction<Object> valueFunc) {
        this.mode = Mode.VarSized;
        this.sizeFunc = sizeFunc;
        this.keyFuncs = new LongFunction[1];
        this.keyFuncs[0] = keyFunc;
        this.valueFuncs = new LongFunction[1];
        this.valueFuncs[0] = valueFunc;
    }

    @SafeVarargs
    @Example(value={"StringMapClob(NumberNameToString(),HashRange(1300,1700),NumberNameToString(),HashRange(3,7))", "create a map of size 2, with a specific function for each key and each value"})
    public StringMapClob(LongFunction<Object> ... objfuncs) {
        this.mode = Mode.Tuples;
        if (objfuncs.length % 2 != 0) {
            throw new RuntimeException("An even number of functions must be provided.");
        }
        int size = objfuncs.length / 2;
        this.sizeFunc = l -> size;
        this.keyFuncs = new LongFunction[size];
        this.valueFuncs = new LongFunction[size];
        for (int i = 0; i < size; ++i) {
            this.keyFuncs[i] = objfuncs[i << 1];
            this.valueFuncs[i] = objfuncs[(i << 1) + 1];
        }
    }

    @Override
    public String apply(long value) {
        StringBuilder sb = tl_sb.get();
        sb.setLength(0);
        sb.append(BEFORE_RESULT);
        int size = this.sizeFunc.applyAsInt(value);
        switch (this.mode) {
            case VarSized: {
                for (int i = 0; i < size; ++i) {
                    Object keyObject = this.keyFuncs[0].apply(value + (long)i);
                    Object valueObject = this.valueFuncs[0].apply(value + (long)i);
                    sb.append("'").append(keyObject).append("'");
                    sb.append(ASSIGNMENT);
                    sb.append("'").append(valueObject).append("'");
                    sb.append(BETWEEN_ENTRIES);
                }
                break;
            }
            case Tuples: {
                for (int i = 0; i < this.keyFuncs.length; ++i) {
                    Object keyObject = this.keyFuncs[i].apply(value + (long)i);
                    Object valueObject = this.valueFuncs[i].apply(value + (long)i);
                    sb.append("'").append(keyObject).append("'");
                    sb.append(ASSIGNMENT);
                    sb.append("'").append(valueObject).append("'");
                    sb.append(BETWEEN_ENTRIES);
                }
                break;
            }
        }
        sb.setLength(sb.length() - BETWEEN_ENTRIES.length());
        sb.append(AFTER_RESULT);
        return sb.toString();
    }

    private static enum Mode {
        VarSized,
        Tuples;

    }
}

