/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.datamappers.functions.collections;

import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.core.bindings.DataMapper;
import io.nosqlbench.virtdata.core.bindings.VirtData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class ListMapper
implements LongFunction<List<?>> {
    private int size;
    private DataMapper<String> elementMapper;

    @Example(value={"ListMapper(5,NumberNameToString())", "creates a list of number names"})
    public ListMapper(int size, String genSpec) {
        this.size = size;
        this.elementMapper = VirtData.getMapper(genSpec, String.class);
    }

    @Override
    public List<?> apply(long value) {
        ArrayList<String> list = new ArrayList<String>(this.size);
        for (int listpos = 0; listpos < this.size; ++listpos) {
            String o = this.elementMapper.get(value + (long)listpos);
            list.add(o);
        }
        return list;
    }
}

