/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.datamappers.functions.diagnostics;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;

@ThreadSafeMapper
public class ToCqlType
implements Function<Object, String> {
    private static final Map<String, String> typemap = new HashMap<String, String>(){
        {
            this.put("a", "b");
            this.put(String.class.getCanonicalName(), DataType.text().getName().toString() + " or " + DataType.ascii().getName().toString() + " or " + DataType.varchar().getName().toString());
            this.put(Long.class.getCanonicalName(), DataType.bigint().getName().toString() + " or " + DataType.time().getName().toString() + " or " + DataType.counter().getName().toString());
            this.put(Long.TYPE.getCanonicalName(), DataType.bigint().getName().toString() + " or " + DataType.counter().getName().toString());
            this.put(ByteBuffer.class.getCanonicalName(), DataType.blob().getName().toString() + ",CUSTOM");
            this.put(Boolean.class.getCanonicalName(), DataType.cboolean().getName().toString());
            this.put(Boolean.TYPE.getCanonicalName(), DataType.cboolean().getName().toString());
            this.put(BigDecimal.class.getCanonicalName(), DataType.decimal().getName().toString());
            this.put(Double.class.getCanonicalName(), DataType.cdouble().getName().toString());
            this.put(Double.TYPE.getCanonicalName(), DataType.cdouble().getName().toString());
            this.put(Float.class.getCanonicalName(), DataType.cfloat().getName().toString());
            this.put(Float.TYPE.getCanonicalName(), DataType.cfloat().getName().toString());
            this.put(InetAddress.class.getCanonicalName(), DataType.inet().getName().toString());
            this.put(Integer.class.getCanonicalName(), DataType.cint().getName().toString());
            this.put(Integer.TYPE.getCanonicalName(), DataType.cint().getName().toString());
            this.put(Date.class.getCanonicalName(), DataType.timestamp().getName().toString());
            this.put(UUID.class.getCanonicalName(), DataType.timeuuid().getName().toString() + " or " + DataType.uuid().getName().toString());
            this.put(BigInteger.class.getCanonicalName(), DataType.varint().getName().toString());
            this.put(Short.class.getCanonicalName(), DataType.smallint().getName().toString());
            this.put(Short.TYPE.getCanonicalName(), DataType.smallint().getName().toString());
            this.put(Byte.class.getCanonicalName(), DataType.tinyint().getName().toString());
            this.put(Byte.TYPE.getCanonicalName(), DataType.tinyint().getName().toString());
            this.put(LocalDate.class.getCanonicalName(), DataType.date().getName().toString());
            this.put(UDTValue.class.getCanonicalName(), "<udt>");
            this.put(TupleValue.class.getCanonicalName(), "<tuple>");
        }
    };
    private final ThreadLocal<StringBuilder> tlsb = ThreadLocal.withInitial(StringBuilder::new);

    @Override
    public String apply(Object o) {
        String canonicalName = o.getClass().getCanonicalName();
        String cqlTypeName = typemap.get(canonicalName);
        StringBuilder sb = this.tlsb.get();
        sb.setLength(0);
        if (cqlTypeName != null) {
            return sb.append(canonicalName).append(" -> ").append(cqlTypeName).toString();
        }
        return this.findAlternates(o, canonicalName);
    }

    private String findAlternates(Object o, String canonicalName) {
        StringBuilder sb = this.tlsb.get();
        if (List.class.isAssignableFrom(o.getClass())) {
            sb.append(canonicalName).append("<");
            if (((List)o).size() > 0) {
                Object o1 = ((List)o).get(0);
                String elementType = o1.getClass().getCanonicalName();
                sb.append(elementType).append("> -> List<");
                sb.append(typemap.getOrDefault(elementType, "UNKNOWN")).append(">");
                return sb.toString();
            }
            return sb.append("?> -> List<?>").toString();
        }
        if (Map.class.isAssignableFrom(o.getClass())) {
            sb.append(canonicalName).append("<");
            if (((Map)o).size() > 0) {
                Map.Entry next = ((Map)o).entrySet().iterator().next();
                String keyType = next.getKey().getClass().getCanonicalName();
                String valType = next.getValue().getClass().getCanonicalName();
                sb.append(keyType).append(",").append(valType).append("> -> Map<");
                sb.append(typemap.getOrDefault(keyType, "UNKNOWN")).append(",");
                sb.append(typemap.getOrDefault(valType, "UNKNOWN")).append(">");
                return sb.toString();
            }
            return sb.append("?,?> -> Map<?,?>").toString();
        }
        if (Set.class.isAssignableFrom(o.getClass())) {
            sb.append(canonicalName).append("<");
            if (((Set)o).size() > 0) {
                Object o1 = ((Set)o).iterator().next();
                String elementType = o1.getClass().getCanonicalName();
                sb.append(elementType).append("> -> Set<");
                sb.append(typemap.getOrDefault(elementType, "UNKNOWN")).append(">");
                return sb.toString();
            }
            return sb.append("?> -> Set<?>").toString();
        }
        return typemap.getOrDefault(o.getClass().getSuperclass().getCanonicalName(), "UNKNOWN");
    }
}

