/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.datamappers.functions.geometry;

import io.nosqlbench.activitytype.cql.datamappers.functions.geometry.Point;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;

@ThreadSafeMapper
public class Distance
implements LongFunction<com.datastax.driver.dse.geometry.Distance> {
    private final Point pointfunc;
    private final LongToDoubleFunction rfunc;

    public Distance(LongToDoubleFunction xfunc, LongToDoubleFunction yfunc, LongToDoubleFunction rfunc) {
        this.pointfunc = new Point(xfunc, yfunc);
        this.rfunc = rfunc;
    }

    public Distance(double x, LongToDoubleFunction yfunc, LongToDoubleFunction rfunc) {
        this.pointfunc = new Point(u -> x, yfunc);
        this.rfunc = rfunc;
    }

    public Distance(LongToDoubleFunction xfunc, double y, LongToDoubleFunction rfunc) {
        this.pointfunc = new Point(xfunc, v -> y);
        this.rfunc = rfunc;
    }

    public Distance(double x, double y, LongToDoubleFunction rfunc) {
        this.pointfunc = new Point(u -> x, v -> y);
        this.rfunc = rfunc;
    }

    public Distance(LongToDoubleFunction xfunc, LongToDoubleFunction yfunc, double r) {
        this.pointfunc = new Point(xfunc, yfunc);
        this.rfunc = w -> r;
    }

    public Distance(double x, LongToDoubleFunction yfunc, double r) {
        this.pointfunc = new Point(u -> x, yfunc);
        this.rfunc = w -> r;
    }

    public Distance(LongToDoubleFunction xfunc, double y, double r) {
        this.pointfunc = new Point(xfunc, v -> y);
        this.rfunc = w -> r;
    }

    public Distance(double x, double y, double r) {
        this.pointfunc = new Point(u -> x, v -> y);
        this.rfunc = w -> r;
    }

    @Override
    public com.datastax.driver.dse.geometry.Distance apply(long value) {
        com.datastax.driver.dse.geometry.Point apoint = this.pointfunc.apply(value);
        double aradius = this.rfunc.applyAsDouble(value);
        return new com.datastax.driver.dse.geometry.Distance(apoint, aradius);
    }
}

