/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.datamappers.functions.geometry;

import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Polygon;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.curves4.discrete.long_int.Uniform;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class PolygonOnGrid
implements LongFunction<Polygon> {
    private final double rows;
    private final double columns;
    private final double x_topleft;
    private final double y_topleft;
    private final double x_bottomright;
    private final double y_bottomright;
    private final Uniform rowfunc;
    private final Uniform colfunc;
    private final double xwidth;
    private final double yheight;

    @Example(value={"PolygonOnGrid(1, 11, 11, 1, 10, 10)", "Create a 10x10 grid with cells 1x1, spaced one off the y=0 and x=0 axes"})
    public PolygonOnGrid(double x_topleft, double y_topleft, double x_bottomright, double y_bottomright, int rows, int columns) {
        if (x_topleft >= x_bottomright) {
            throw new RuntimeException("x_topleft should be less than x_bottomright");
        }
        if (y_topleft <= y_bottomright) {
            throw new RuntimeException("y_topleft should be more than y_bottomright");
        }
        this.x_topleft = x_topleft;
        this.y_topleft = y_topleft;
        this.x_bottomright = x_bottomright;
        this.y_bottomright = y_bottomright;
        this.rows = rows;
        this.columns = columns;
        this.xwidth = (x_bottomright - x_topleft) / (double)columns;
        this.yheight = (y_topleft - y_bottomright) / (double)columns;
        this.rowfunc = new Uniform(0, rows - 1, new String[0]);
        this.colfunc = new Uniform(0, columns - 1, new String[0]);
    }

    @Override
    public Polygon apply(long value) {
        int row = this.rowfunc.applyAsInt(value);
        int column = this.colfunc.applyAsInt(value + 33L);
        double left = this.x_topleft + (double)column * this.xwidth;
        double top = this.y_topleft - (double)row * this.yheight;
        double right = left + this.xwidth;
        double bottom = top - this.yheight;
        Polygon polygon = new Polygon(new Point(left, bottom), new Point(left, top), new Point(right, top), new Point(right, bottom));
        return polygon;
    }
}

