/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.datamappers.functions.long_localdate;

import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class EpochMillisToJavaLocalDate
implements LongFunction<LocalDate> {
    ZoneId timezone;

    @Example(value={"EpochMillisToJavaLocalDate()", "Yields the LocalDate for the system default ZoneId"})
    public EpochMillisToJavaLocalDate() {
        this.timezone = ZoneId.systemDefault();
    }

    @Example(value={"EpochMillisToJavaLocalDate('ECT')", "Yields the LocalDate for the ZoneId entry for 'Europe/Paris'"})
    public EpochMillisToJavaLocalDate(String zoneid) {
        this.timezone = ZoneId.of(zoneid);
    }

    @Override
    public LocalDate apply(long value) {
        return Instant.ofEpochMilli(value).atZone(this.timezone).toLocalDate();
    }
}

