/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.datamappers.functions.long_localdate;

import io.nosqlbench.nb.annotations.Service;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.processors.DocCtorData;
import io.nosqlbench.virtdata.api.processors.DocForFuncCtor;
import io.nosqlbench.virtdata.api.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service(value=DocFuncData.class)
public class EpochMillisToJavaLocalDateAutoDocsInfo
implements DocFuncData {
    @Override
    public String getClassName() {
        return "EpochMillisToJavaLocalDate";
    }

    @Override
    public String getPackageName() {
        return "io.nosqlbench.activitytype.cql.datamappers.functions.long_localdate";
    }

    @Override
    public String getClassJavadoc() {
        return "Converts epoch millis to a java.time.{@link LocalDate} object,\nusing either the system\ndefault timezone or the timezone provided. If the specified ZoneId is not\nthe same as the time base of the epoch millis instant, then conversion\nerrors will occur.\n\nShort form ZoneId values like 'CST' can be used, although US Domestic names\nwhich specify the daylight savings hours are not supported. The full list of\nshort Ids at @see <a href=\"https://docs.oracle.com/en/java/javase/12/docs/api/java.base/java/time/ZoneId.html#SHORT_IDS\">JavaSE ZoneId Ids</a>\n\nAny timezone specifier may be used which can be read by {@link ZoneId#of(String)}\n";
    }

    @Override
    public String getInType() {
        return "long";
    }

    @Override
    public String getOutType() {
        return "java.time.LocalDate";
    }

    @Override
    public Category[] getCategories() {
        return new Category[0];
    }

    @Override
    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("EpochMillisToJavaLocalDate", "", (Map<String, String>)new LinkedHashMap<String, String>(){}, (List<List<String>>)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("EpochMillisToJavaLocalDate()");
                                this.add("Yields the LocalDate for the system default ZoneId");
                            }
                        });
                    }
                }));
                this.add(new DocForFuncCtor("EpochMillisToJavaLocalDate", "", (Map<String, String>)new LinkedHashMap<String, String>(){
                    {
                        this.put("zoneid", "java.lang.String");
                    }
                }, (List<List<String>>)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("EpochMillisToJavaLocalDate('ECT')");
                                this.add("Yields the LocalDate for the ZoneId entry for 'Europe/Paris'");
                            }
                        });
                    }
                }));
            }
        };
    }
}

