/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.datamappers.functions.long_localdate;

import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class EpochMillisToJavaLocalDateTime
implements LongFunction<LocalDateTime> {
    ZoneId timezone;

    @Example(value={"EpochMillisToJavaLocalDateTime()", "Yields the LocalDateTime for the system default ZoneId"})
    public EpochMillisToJavaLocalDateTime() {
        this.timezone = ZoneId.systemDefault();
    }

    @Example(value={"EpochMillisToJavaLocalDateTime('ECT')", "Yields the LocalDateTime for the ZoneId entry for 'Europe/Paris'"})
    public EpochMillisToJavaLocalDateTime(String zoneid) {
        this.timezone = ZoneId.of(zoneid);
    }

    @Override
    public LocalDateTime apply(long value) {
        return Instant.ofEpochMilli(value).atZone(this.timezone).toLocalDateTime();
    }
}

