/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.datamappers.functions.long_string;

import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_string.ModuloLineToString;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.LongFunction;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeMapper
public class ModuloCSVLineToUUID
implements LongFunction<UUID> {
    private static final Logger logger = LoggerFactory.getLogger(ModuloLineToString.class);
    private List<String> lines = new ArrayList<String>();
    private String filename;

    @Example(value={"ModuloCSVLineToUUID('data/myfile.csv','lat')", "load values for 'lat' from the CSV file myfile.csv."})
    public ModuloCSVLineToUUID(String filename, String fieldname) {
        this.filename = filename;
        CSVParser csvp = NBIO.readFileCSV(filename, new String[0]);
        int column = csvp.getHeaderMap().get(fieldname);
        for (CSVRecord strings : csvp) {
            this.lines.add(strings.get(column));
        }
    }

    @Override
    public UUID apply(long input) {
        int itemIdx = (int)(input % (long)this.lines.size()) % Integer.MAX_VALUE;
        String item = this.lines.get(itemIdx);
        return UUID.fromString(item);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.filename;
    }
}

