/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.datamappers.functions.rainbow;

import io.nosqlbench.activitytype.cql.datamappers.functions.rainbow.TokenMapFileSharedBuffers;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class TokenMapFileAPIService {
    private final int recordCount;
    private final ByteBuffer buffer;
    private final int RECORD_LEN = 16;
    private int recordPosition;
    private long token;
    private int TOKEN_OFFSET = 0;
    private long cycle;
    private int CYCLE_OFFSET = 8;
    private boolean loopdata;

    public TokenMapFileAPIService(String datafile, boolean loopdata, boolean instanced, boolean ascending) {
        this.loopdata = loopdata;
        this.buffer = TokenMapFileSharedBuffers.getByteBuffer(datafile, instanced, ascending).asReadOnlyBuffer();
        this.recordCount = this.buffer.capacity() / 16;
        this.recordPosition = 0;
    }

    public synchronized void next() {
        try {
            this.token = this.buffer.getLong();
            this.cycle = this.buffer.getLong();
        }
        catch (BufferUnderflowException bue) {
            if (this.loopdata) {
                this.buffer.position(0);
                this.next();
            }
            throw bue;
        }
    }

    public void next(int position) {
        if (this.loopdata) {
            position = position % this.recordCount * 16;
        }
        this.token = this.buffer.getLong(position + this.TOKEN_OFFSET);
        this.cycle = this.buffer.getLong(position + this.CYCLE_OFFSET);
    }

    public long getToken() {
        return this.token;
    }

    public long getCycle() {
        return this.cycle;
    }
}

