/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.datamappers.functions.rainbow;

import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;

public class TokenMapFileSharedBuffers {
    public static final TokenMapFileSharedBuffers INSTANCE = new TokenMapFileSharedBuffers();
    private static final Map<String, ByteBuffer> BUFFERS = new HashMap<String, ByteBuffer>();

    private TokenMapFileSharedBuffers() {
    }

    public static synchronized ByteBuffer getByteBuffer(String filename, boolean instanced, boolean ascending) {
        ByteBuffer foundBuffer = BUFFERS.computeIfAbsent(filename, f -> TokenMapFileSharedBuffers.load(f, ascending));
        return instanced ? foundBuffer.asReadOnlyBuffer() : foundBuffer;
    }

    private static ByteBuffer load(String filename, boolean ascending) {
        try {
            RandomAccessFile image = new RandomAccessFile(filename, "rw");
            ByteBuffer mbb = image.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, image.length());
            if (!ascending) {
                int RECORD_LEN = 16;
                ByteBuffer descendingByteBuffer = ByteBuffer.allocate(mbb.capacity());
                for (int i = mbb.capacity() - RECORD_LEN; i >= 0; i -= RECORD_LEN) {
                    long v1 = mbb.getLong(i);
                    long v2 = mbb.getLong(i + 8);
                    descendingByteBuffer.putLong(v1);
                    descendingByteBuffer.putLong(v2);
                }
                mbb = descendingByteBuffer;
            }
            return mbb;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

