/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.datamappers.functions.to_daterange;

import com.datastax.driver.dse.search.DateRange;
import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.Date;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
@Categories(value={Category.datetime})
public class DateRangeFunc
implements LongFunction<DateRange> {
    private final DateRange.DateRangeBound.Precision precision;
    private final LongUnaryOperator lower;
    private final LongUnaryOperator upper;

    public DateRangeFunc(String precision, LongUnaryOperator lower, LongUnaryOperator upper) {
        this.precision = DateRange.DateRangeBound.Precision.valueOf(precision.toUpperCase());
        this.lower = lower;
        this.upper = upper;
    }

    public DateRangeFunc(String precision, LongFunction<Long> lower, LongFunction<Long> upper) {
        this.precision = DateRange.DateRangeBound.Precision.valueOf(precision.toUpperCase());
        this.lower = lower::apply;
        this.upper = upper::apply;
    }

    public DateRangeFunc(String precision, Function<Long, Long> lower, Function<Long, Long> upper) {
        this.precision = DateRange.DateRangeBound.Precision.valueOf(precision.toUpperCase());
        this.lower = lower::apply;
        this.upper = upper::apply;
    }

    @Override
    public DateRange apply(long value) {
        Date lowerDate = new Date(this.lower.applyAsLong(value));
        DateRange.DateRangeBound lower = DateRange.DateRangeBound.lowerBound(lowerDate, this.precision);
        Date upperDate = new Date(this.upper.applyAsLong(value));
        DateRange.DateRangeBound upper = DateRange.DateRangeBound.upperBound(lowerDate, this.precision);
        DateRange dateRange = new DateRange(lower, upper);
        return dateRange;
    }
}

