/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.datamappers.functions.to_daterange;

import com.datastax.driver.dse.search.DateRange;
import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.Examples;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.Date;
import java.util.function.LongFunction;

@ThreadSafeMapper
@Categories(value={Category.datetime})
public class DateRangeOnOrBefore
implements LongFunction<DateRange> {
    private final DateRange.DateRangeBound.Precision precision;

    @Examples(value={@Example(value={"DateRangeOnOrBefore('millisecond')}", "Convert the incoming millisecond to match anything on or before it."}), @Example(value={"DateRangeOnOrBefore('minute')}", "Convert the incoming millisecond to match anything on or before the minute in which the millisecond falls"})})
    public DateRangeOnOrBefore(String precision) {
        this.precision = DateRange.DateRangeBound.Precision.valueOf(precision.toUpperCase());
    }

    @Override
    public DateRange apply(long value) {
        Date date = new Date(value);
        DateRange.DateRangeBound lower = DateRange.DateRangeBound.UNBOUNDED;
        DateRange.DateRangeBound upper = DateRange.DateRangeBound.upperBound(date, this.precision);
        DateRange dateRange = new DateRange(lower, upper);
        return dateRange;
    }
}

