/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.datamappers.functions.to_daterange;

import com.datastax.driver.dse.search.DateRange;
import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.text.ParseException;
import java.util.function.Function;

@ThreadSafeMapper
@Categories(value={Category.datetime})
public class DateRangeParser
implements Function<String, DateRange> {
    private final DateRange.DateRangeBound.Precision precision;

    @Example(value={"DateRangeParser()}", "Convert inputs like '[1970-01-01T00:00:00 TO 1970-01-01T00:00:00]' into DateRanges "})
    public DateRangeParser(String precision) {
        this.precision = DateRange.DateRangeBound.Precision.valueOf(precision.toUpperCase());
    }

    @Override
    public DateRange apply(String value) {
        try {
            return DateRange.parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException("unable to parse date rage input '" + value + "': error:" + e.getMessage());
        }
    }
}

