/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.errorhandling;

import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.BootstrappingException;
import com.datastax.driver.core.exceptions.BusyConnectionException;
import com.datastax.driver.core.exceptions.BusyPoolException;
import com.datastax.driver.core.exceptions.CodecNotFoundException;
import com.datastax.driver.core.exceptions.ConnectionException;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.FrameTooLongException;
import com.datastax.driver.core.exceptions.FunctionExecutionException;
import com.datastax.driver.core.exceptions.InvalidConfigurationInQueryException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.OperationTimedOutException;
import com.datastax.driver.core.exceptions.OverloadedException;
import com.datastax.driver.core.exceptions.PagingStateException;
import com.datastax.driver.core.exceptions.ProtocolError;
import com.datastax.driver.core.exceptions.QueryConsistencyException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import com.datastax.driver.core.exceptions.QueryValidationException;
import com.datastax.driver.core.exceptions.ReadFailureException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.ServerError;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.exceptions.TraceRetrievalException;
import com.datastax.driver.core.exceptions.TransportException;
import com.datastax.driver.core.exceptions.TruncateException;
import com.datastax.driver.core.exceptions.UnauthorizedException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.UnpreparedException;
import com.datastax.driver.core.exceptions.UnresolvedUserTypeException;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import com.datastax.driver.core.exceptions.UnsupportedProtocolVersionException;
import com.datastax.driver.core.exceptions.WriteFailureException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.ChangeUnappliedCycleException;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.CqlGenericCycleException;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.MaxTriesExhaustedException;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.ResultSetVerificationException;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.RowVerificationException;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.UnexpectedPagingException;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.results.ResultReadable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CQLExceptionEnum implements ResultReadable
{
    FrameTooLongException(FrameTooLongException.class, 1),
    CodecNotFoundException(CodecNotFoundException.class, 2),
    DriverException(DriverException.class, 3),
    AuthenticationException(AuthenticationException.class, 4),
    TraceRetrievalException(TraceRetrievalException.class, 5),
    UnsupportedProtocolVersionException(UnsupportedProtocolVersionException.class, 6),
    NoHostAvailableException(NoHostAvailableException.class, 7),
    QueryValidationException(QueryValidationException.class, 8),
    InvalidQueryException(InvalidQueryException.class, 9),
    InvalidConfigurationInQueryException(InvalidConfigurationInQueryException.class, 10),
    UnauthorizedException(UnauthorizedException.class, 11),
    SyntaxError(SyntaxError.class, 12),
    AlreadyExistsException(AlreadyExistsException.class, 13),
    UnpreparedException(UnpreparedException.class, 14),
    InvalidTypeException(InvalidTypeException.class, 15),
    QueryExecutionException(QueryExecutionException.class, 16),
    UnavailableException(UnavailableException.class, 17),
    BootstrappingException(BootstrappingException.class, 18),
    OverloadedException(OverloadedException.class, 19),
    TruncateException(TruncateException.class, 20),
    QueryConsistencyException(QueryConsistencyException.class, 21),
    WriteTimeoutException(WriteTimeoutException.class, 22),
    WriteFailureException(WriteFailureException.class, 23),
    ReadFailureException(ReadFailureException.class, 24),
    ReadTimeoutException(ReadTimeoutException.class, 25),
    FunctionExecutionException(FunctionExecutionException.class, 26),
    DriverInternalError(DriverInternalError.class, 27),
    ProtocolError(ProtocolError.class, 28),
    ServerError(ServerError.class, 29),
    BusyPoolException(BusyPoolException.class, 30),
    ConnectionException(ConnectionException.class, 31),
    TransportException(TransportException.class, 32),
    OperationTimedOutException(OperationTimedOutException.class, 33),
    PagingStateException(PagingStateException.class, 34),
    UnresolvedUserTypeException(UnresolvedUserTypeException.class, 35),
    UnsupportedFeatureException(UnsupportedFeatureException.class, 36),
    BusyConnectionException(BusyConnectionException.class, 37),
    ChangeUnappliedCycleException(ChangeUnappliedCycleException.class, 38),
    ResultSetVerificationException(ResultSetVerificationException.class, 39),
    RowVerificationException(RowVerificationException.class, 40),
    UnexpectedPagingException(UnexpectedPagingException.class, 41),
    EbdseCycleException(CqlGenericCycleException.class, 42),
    MaxTriesExhaustedException(MaxTriesExhaustedException.class, 43);

    private static final Logger logger;
    private static Map<String, Integer> codesByName;
    private static String[] namesByCode;
    private final Class<? extends Exception> exceptionClass;
    private final int resultCode;

    private CQLExceptionEnum(Class<? extends Exception> clazz, int resultCode) {
        this.exceptionClass = clazz;
        this.resultCode = resultCode;
    }

    public Class<? extends Exception> getExceptionClass() {
        return this.exceptionClass;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    @Override
    public int getResult() {
        return this.resultCode;
    }

    private static Map<String, Integer> getCodesByName() {
        codesByName = new HashMap<String, Integer>();
        for (CQLExceptionEnum cqlExceptionEnum : CQLExceptionEnum.values()) {
            codesByName.put(cqlExceptionEnum.toString(), cqlExceptionEnum.resultCode);
        }
        codesByName.put("NONE", 0);
        return codesByName;
    }

    private static String[] getNamesByCode() {
        ArrayList<String> namesByCode = new ArrayList<String>();
        namesByCode.add("NONE");
        for (CQLExceptionEnum cqlExceptionEnum : CQLExceptionEnum.values()) {
            int code = cqlExceptionEnum.resultCode;
            for (int i = namesByCode.size(); i <= code; ++i) {
                namesByCode.add("UNKNOWN");
            }
            namesByCode.set(code, cqlExceptionEnum.toString());
        }
        return namesByCode.toArray(new String[0]);
    }

    static {
        logger = LoggerFactory.getLogger(CQLExceptionEnum.class);
        codesByName = CQLExceptionEnum.getCodesByName();
        namesByCode = CQLExceptionEnum.getNamesByCode();
    }
}

