/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.errorhandling;

import io.nosqlbench.activitytype.cql.api.ErrorResponse;
import io.nosqlbench.activitytype.cql.errorhandling.ErrorStatus;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.CQLCycleWithStatementException;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.CQLExceptionDetailer;
import io.nosqlbench.engine.api.activityapi.errorhandling.CycleErrorHandler;
import io.nosqlbench.engine.api.metrics.ExceptionCountMetrics;
import io.nosqlbench.engine.api.metrics.ExceptionHistoMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NBCycleErrorHandler
implements CycleErrorHandler<Throwable, ErrorStatus> {
    private static final Logger logger = LoggerFactory.getLogger(NBCycleErrorHandler.class);
    private ErrorResponse errorResponse;
    private ExceptionCountMetrics exceptionCountMetrics;
    private final ExceptionHistoMetrics exceptionHistoMetrics;
    private boolean throwExceptionOnStop = false;

    public NBCycleErrorHandler(ErrorResponse errorResponse, ExceptionCountMetrics exceptionCountMetrics, ExceptionHistoMetrics exceptionHistoMetrics, boolean throwExceptionOnStop) {
        this.errorResponse = errorResponse;
        this.exceptionCountMetrics = exceptionCountMetrics;
        this.exceptionHistoMetrics = exceptionHistoMetrics;
        this.throwExceptionOnStop = throwExceptionOnStop;
    }

    @Override
    public ErrorStatus handleError(long cycle, Throwable contextError) {
        CQLCycleWithStatementException cce = (CQLCycleWithStatementException)contextError;
        Throwable error = cce.getCause();
        boolean retry = false;
        switch (this.errorResponse) {
            case stop: {
                logger.error("error with cycle " + cycle + ": statement: " + cce.getStatement() + " errmsg: " + CQLExceptionDetailer.messageFor(cycle, error));
                if (this.throwExceptionOnStop) {
                    throw new RuntimeException(error);
                }
            }
            case warn: {
                logger.warn("error with cycle " + cycle + ": statement: " + cce.getStatement() + " errmsg: " + CQLExceptionDetailer.messageFor(cycle, error));
            }
            case retry: {
                retry = true;
            }
            case histogram: {
                this.exceptionHistoMetrics.update(error, cce.getDurationNanos());
            }
            case count: {
                this.exceptionCountMetrics.count(error);
            }
        }
        return new ErrorStatus(this.errorResponse, retry, -1);
    }

    @Override
    public ErrorStatus handleError(long cycle, Throwable contextError, String errMsg) {
        return this.handleError(cycle, contextError);
    }

    public String toString() {
        return this.errorResponse.toString();
    }
}

