/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.errorhandling.exceptions;

import com.datastax.driver.core.ResultSet;
import io.nosqlbench.activitytype.cql.errorhandling.exceptions.CqlGenericCycleException;

public class UnexpectedPagingException
extends CqlGenericCycleException {
    private final ResultSet resultSet;
    private final String queryString;
    private final int fetchSize;
    private int fetchedPages;
    private int maxpages;

    public UnexpectedPagingException(long cycle, ResultSet resultSet, String queryString, int fetchedPages, int maxpages, int fetchSize) {
        super(cycle);
        this.resultSet = resultSet;
        this.queryString = queryString;
        this.fetchedPages = fetchedPages;
        this.maxpages = maxpages;
        this.fetchSize = fetchSize;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Additional paging would be required to read the results from this query fully, but the user has not explicitly indicated that paging was expected.").append(" fetched/allowed: ").append(this.fetchedPages).append("/").append(this.maxpages).append(" fetchSize(").append(this.fetchSize).append("): ").append(this.queryString);
        return sb.toString();
    }
}

