/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.statements.binders;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import io.nosqlbench.activitytype.cql.core.CQLBindHelper;
import io.nosqlbench.virtdata.core.bindings.ValuesArrayBinder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticPreparedBinder
implements ValuesArrayBinder<PreparedStatement, Statement> {
    public static final Logger logger = LoggerFactory.getLogger(DiagnosticPreparedBinder.class);

    @Override
    public Statement bindValues(PreparedStatement prepared, Object[] values) {
        ColumnDefinitions columnDefinitions = prepared.getVariables();
        BoundStatement bound = prepared.bind();
        if (columnDefinitions.asList().size() != values.length) {
            throw new RuntimeException("The number of named anchors in your statement does not match the number of bindings provided.");
        }
        List<ColumnDefinitions.Definition> columnDefList = columnDefinitions.asList();
        int i = 0;
        for (Object value : values) {
            if (columnDefList.size() <= i) {
                logger.error("what gives?");
            }
            ColumnDefinitions.Definition columnDef = columnDefList.get(i);
            String colName = columnDef.getName();
            DataType.Name type = columnDef.getType().getName();
            try {
                bound = CQLBindHelper.bindStatement(bound, colName, value, type);
            }
            catch (ClassCastException e) {
                logger.error(String.format("Unable to bind column %s to cql type %s with value %s", new Object[]{colName, type, value}));
                throw e;
            }
            ++i;
        }
        return bound;
    }
}

