/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.statements.binders;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import io.nosqlbench.activitytype.cql.statements.binders.DiagnosticPreparedBinder;
import io.nosqlbench.virtdata.core.bindings.ValuesArrayBinder;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectArrayValuesBinder
implements ValuesArrayBinder<PreparedStatement, Statement> {
    public static final Logger logger = LoggerFactory.getLogger(DirectArrayValuesBinder.class);

    @Override
    public Statement bindValues(PreparedStatement preparedStatement, Object[] objects) {
        try {
            return preparedStatement.bind(objects);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Error binding objects to prepared statement directly, falling back to diagnostic binding layer:");
            sb.append(Arrays.toString(objects));
            logger.warn(sb.toString(), e);
            DiagnosticPreparedBinder diag = new DiagnosticPreparedBinder();
            return diag.bindValues(preparedStatement, objects);
        }
    }
}

