/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.cql.statements.binders;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import io.nosqlbench.virtdata.core.bindings.ValuesArrayBinder;

public class SimpleStatementValuesBinder
implements ValuesArrayBinder<SimpleStatement, Statement> {
    private final boolean parametrized;

    public SimpleStatementValuesBinder(boolean parametrized) {
        this.parametrized = parametrized;
    }

    @Override
    public Statement bindValues(SimpleStatement context, Object[] values) {
        Boolean idempotent;
        ConsistencyLevel serial_cl;
        String query = context.getQueryString();
        if (this.parametrized) {
            String[] splits = query.split("\\?");
            assert (splits.length == values.length + 1);
            StringBuilder sb = new StringBuilder();
            sb.append(splits[0]);
            for (int i = 1; i < splits.length; ++i) {
                sb.append(values[i - 1]);
                sb.append(splits[i]);
            }
            query = sb.toString();
            System.out.println(query);
        }
        SimpleStatement simpleStatement = new SimpleStatement(query);
        ConsistencyLevel cl = context.getConsistencyLevel();
        if (cl != null) {
            simpleStatement.setConsistencyLevel(context.getConsistencyLevel());
        }
        if ((serial_cl = context.getSerialConsistencyLevel()) != null) {
            simpleStatement.setSerialConsistencyLevel(context.getSerialConsistencyLevel());
        }
        if ((idempotent = context.isIdempotent()) != null) {
            simpleStatement.setIdempotent(idempotent);
        }
        return simpleStatement;
    }
}

